module reg_day_mask ( input logic clk,  input logic ares,
                      apb_if.slave apb, output logic [31:1] dayMask );

    import apb_pkg::*;

    always_ff @( posedge clk or posedge ares )
        if ( ares ) begin
            dayMask  <= '1;
            apb.resp <= '{ default: 0 };
        end
        else begin
            if ( apb.WriteReg( REG_DAY_MASK ) )
                dayMask <= apb.req.wdata[0+:$bits(dayMask)];

            if ( apb.ReadReg( REG_DAY_MASK ) )
                apb.resp <= '{ ready: 1, rdata: apb_data_t'(dayMask) };
            else
                apb.resp <= '{ default: 0 };
        end

endmodule
