`include "WORKAROUND.svh"

import other_pkg::*;

module reg_bd_month ( input logic clk, input logic ares,
                      apb_if.slave apb,
		      output MONTH_e [FAMILY_SIZE-1:0] bdMonth );

    import apb_pkg::*;

    apb_resp_s resp;
    const apb_addr_e start_reg = REG_BD_MONTH_MOM;

    always_comb begin
	resp = '{ default: 0 };
`ifdef WORKAROUND_foreach
	for ( int i = 0; i < $size(bdMonth); i++ ) begin
`else
	foreach ( bdMonth[i] ) begin
`endif
`ifdef WORKAROUND_next_i
	    if ( apb.ReadReg( apb_addr_e'( REG_BD_MONTH_MOM + i ) ) )
`else
	    if ( apb.ReadReg( start_reg.next(i) ) )
`endif
		resp = '{ ready: 1,
                          rdata: apb_data_t'( bdMonth[i] ) };
	end
    end

    localparam int width = $bits(MONTH_e);

    always_ff @( posedge clk or posedge ares ) begin
        if ( ares ) begin
`ifdef WORKAROUND_default_enum_array_explicit
            bdMonth  <= {$size(bdMonth){JAN}};
`elsif WORKAROUND_default_enum_array_low_first
            bdMonth  <= '{ default: JAN };
`else
            bdMonth  <= '{ default: bdMonth[$low(bdMonth)].first };
`endif
            apb.resp <= '{ default: 0 };
        end
        else begin
`ifdef WORKAROUND_foreach
	    for ( int i = 0; i < $size(bdMonth); i++ ) begin
`else
            foreach ( bdMonth[i] ) begin
`endif
`ifdef WORKAROUND_next_i
                if ( apb.WriteReg( apb_addr_e'( REG_BD_MONTH_MOM + i ) ) )
`else
                if ( apb.WriteReg( start_reg.next(i) ) )
`endif
                    bdMonth[i] <= MONTH_e'(apb.req.wdata[0+:width]);
            end
            apb.resp <= resp;
        end
    end

endmodule
