package apb_pkg;
    // AMBA 3 APB Protocol Specification v1.0

    // Addr width unspecified by APB
    // so make a type for flexibility.
    typedef logic [19:2] apb_addr_t;

    typedef enum apb_addr_t {
        REG_BD_MONTH_MOM        = 'h40,
        REG_BD_MONTH_DAD        = 'h41,
        REG_BD_MONTH_DAUGHTER   = 'h42,
        REG_BD_MONTH_SON        = 'h43,
        REG_DAY_MASK            = 'h50,
        REG_TEMP_JAN            = 'h61,
        REG_TEMP_FEB            = 'h62,
        REG_TEMP_MAR            = 'h63,
        REG_TEMP_APR            = 'h64,
        REG_TEMP_MAY            = 'h65,
        REG_TEMP_JUN            = 'h66,
        REG_TEMP_JUL            = 'h67,
        REG_TEMP_AUG            = 'h68,
        REG_TEMP_SEP            = 'h69,
        REG_TEMP_OCT            = 'h6a,
        REG_TEMP_NOV            = 'h6b,
        REG_TEMP_DEC            = 'h6c
    } apb_addr_e;

    // Data width unspecified by APB
    // so make a type for flexibility.
    typedef logic [31:0] apb_data_t;

    // APB request (master to slave).
    typedef struct packed {
        apb_addr_e addr;
        logic      enable;
        logic      write;
        apb_data_t wdata;
    } apb_req_s;

    // APB response (slave to master).
    typedef struct packed {
        logic      ready;
        apb_data_t rdata;
    } apb_resp_s;

    typedef enum int {
        SLAVE_TEMPS,
        SLAVE_BD_MONTH,
        SLAVE_DAY_MASK,
        SLAVE_NUM
    } SLAVE_e;

endpackage
