interface apb_if;

    import apb_pkg::*;

    logic      sel;
    apb_req_s  req;
    apb_resp_s resp;

    function automatic logic WriteReg( input apb_addr_e addr );
        WriteReg = sel & req.write & req.enable & ( req.addr == addr );
    endfunction

    function automatic logic ReadReg( input apb_addr_e addr );
        ReadReg = sel & ~req.write & req.enable & ( req.addr == addr );
    endfunction

    modport master( output req, sel, input  resp );
    modport slave ( input  req, sel, output resp,
                    import WriteReg, import ReadReg );

endinterface
