/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//////////////////////////////////////////////////////////////////////////////////
//
// TESTBENCH FOR MODULE: top_level
//
// DESCRIPTION:
//
//
// this file was generated by 'sca_xml2simple_tb.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////

#define ACCESS_MODULE_COMPONENTS_HIERARCHIC
#define ACCESS_MODULE_STATE_DECLARATION

#include <systemc-ams.h>
#include "../testbench/top_level.h"

//#include "simcontrol_module.h"                                 //SCSimCtrl tool for trace selection and simulation control
#include <sca_basic_libraries/generic_tb_utilities/sim_ctrl.h> //include display current simulation time header


int sc_main(int argc, char* argv[])
{
    sc_set_time_resolution(1.0, SC_FS);
    
    //display current simulation time
    sim_ctrl("show_sim_time", sc_time(0.1,SC_MS));


    //////////////////////////////////////////////////////////////////////////////
    // signal definition                                                        //
    //////////////////////////////////////////////////////////////////////////////

    sca_tdf::sca_signal<sc_int<NBits>      > adc_s("adc_s");
    sc_core::sc_signal<int  > k_s("k_s");



    //////////////////////////////////////////////////////////////////////////////
    //DUT - device under test                                                   //
    //////////////////////////////////////////////////////////////////////////////

    top_level* dut;
    top_level::params p_dut;
    dut = new top_level("dut", p_dut);
      dut -> adc.bind(adc_s);
      dut -> k.bind(k_s);




    //////////////////////////////////////////////////////////////////////////////
    // trace entity signals                                                     //
    //////////////////////////////////////////////////////////////////////////////

    sca_trace_file *tf=sca_create_tabular_trace_file("top_level_trace.dat");
      sca_trace(tf, adc_s, "adc_s");
      sca_trace(tf, k_s, "k_s");
      sca_trace(tf, (*dut)->s_vsource, "s_vsource");
      sca_trace(tf, (*dut)->s_sens_out, "s_sens_out");
      sca_trace(tf, (*dut)->i_sensor_frontend1->s_vamp, "s_vamp");
      sca_trace(tf, (*dut)->i_sensor_frontend1->i_gain_controller1->avr_result, "avr_result");
      sca_trace(tf, (*dut)->i_sensor_frontend1->s_clk, "s_clk");






    //////////////////////////////////////////////////////////////////////////////
    // time domain simulation                                                   //
    //////////////////////////////////////////////////////////////////////////////
    //sc_start (simulation time, SC_SEC | SC_MS | SC_US | SC_NS | SC_PS | SC_FS)
    //sc_start(1.5/fstep*i_fftsink->PERIODS, SC_SEC);
    //sc_start();  //if SCSimControl was hooked up
    sc_start(25.0, SC_MS);


    sc_stop(); //ensures that all sample written and postprocessing executes


    SC_REPORT_INFO("sc_main", (std::string("simulation stopped at ")+sc_time_stamp().to_string()).c_str());
    
    delete dut;
    
    return 0;
}
