////////////////////////////////////////////////////////////////////////////////
//
// PROJECT NAME: vibration_sensor
//
// LIBRARY NAME: testbench
//
// MODULE NAME:  top_level
//
// DESCRIPTION OF MODULE:
//      
//
// DESCRIPTION OF PORTS: 
// adc of type sc_int<NBits>	
//      
// k of type int	
//      
// 
// DESCRIPTION OF PARAMETER:
//
// this file was generated by 'sca_xml2netlist_cpp.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : SystemC AMS netlister
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////

//include submodules
#include "../../vibration_sensor/source/vibration_src.h"
#include "../../vibration_sensor/sensor/vibration_sensor.h"
#include "../frontend/sensor_frontend.h"


#ifndef _VIBRATION_SENSOR_TESTBENCH_TOP_LEVEL_H_
//if this file is not included by the header keep implementation
#include "top_level.h"
#define FHG_INCLUDE_IMPLEMENTATION
#endif



namespace vibration_sensor_namespace
{

//component declarations
struct top_level::components
{

    //declare instance references for external access
    vibration_src& i_vibration_src1;
    vibration_sensor& i_vibration_sensor1;
    sensor_frontend& i_sensor_frontend1;

    //declare node and signal references for external access
    sca_tdf::sca_signal<double	 >& s_vsource;
    sca_tdf::sca_signal<double	 >& s_sens_out;

    //component constructor
    components(
                  vibration_src *i_vibration_src1_,
                  vibration_sensor *i_vibration_sensor1_,
                  sensor_frontend *i_sensor_frontend1_,
                  sca_tdf::sca_signal<double	 > &s_vsource_,
                  sca_tdf::sca_signal<double	 > &s_sens_out_
               ) :
                  i_vibration_src1(*i_vibration_src1_),
                  i_vibration_sensor1(*i_vibration_sensor1_),
                  i_sensor_frontend1(*i_sensor_frontend1_),
                  s_vsource(s_vsource_),
                  s_sens_out(s_sens_out_)
    {}

    //component destructor
    ~components()
    {
        //delete instances
        delete &i_vibration_src1;
        delete &i_vibration_sensor1;
        delete &i_sensor_frontend1;

        //delete signals
        delete &s_vsource;
        delete &s_sens_out;
    }

};


#ifdef FHG_INCLUDE_IMPLEMENTATION


/////////////////////////////////////////////////////////////////////////////
//    architecture implementation (netlist)
/////////////////////////////////////////////////////////////////////////////

void top_level::architecture()
{
  //generate nodes/signals - map to references and name
  sca_tdf::sca_signal<double	 >& s_vsource(* new sca_tdf::sca_signal<double	 >("s_vsource"));
  sca_tdf::sca_signal<double	 >& s_sens_out(* new sca_tdf::sca_signal<double	 >("s_sens_out"));

  ///////////////////////////////////////////////////////////////////////////
  // instantiate modules, assign parameter                                 //
  ///////////////////////////////////////////////////////////////////////////
    vibration_src::params p_i_vibration_src1;
    p_i_vibration_src1.amplitude = 4.0e-6;
    p_i_vibration_src1.offset = -8.0e-6;
    p_i_vibration_src1.f_0 = 2.0e3;
    p_i_vibration_src1.n_period = 8;
    p_i_vibration_src1.n_harmonic = 2;
    p_i_vibration_src1.T_0 = 1.0;
    p_i_vibration_src1.T_period = 1.0;
    vibration_src *i_vibration_src1;
    i_vibration_src1 = new vibration_src("i_vibration_src1", p_i_vibration_src1);
    //port binding see netlist section

    vibration_sensor::params p_i_vibration_sensor1;
    p_i_vibration_sensor1.k = 1.0;
    vibration_sensor *i_vibration_sensor1;
    i_vibration_sensor1 = new vibration_sensor("i_vibration_sensor1", p_i_vibration_sensor1);
    //port binding see netlist section

    sensor_frontend::params p_i_sensor_frontend1;
    sensor_frontend *i_sensor_frontend1;
    i_sensor_frontend1 = new sensor_frontend("i_sensor_frontend1", p_i_sensor_frontend1);
    //port binding see netlist section


  ///////////////////////////////////////////////////////////////////////////
  // netlist section                                                       //
  ///////////////////////////////////////////////////////////////////////////
    //i_vibration_src1 (vibration_src)
    i_vibration_src1 -> out.bind(s_vsource);

    //i_vibration_sensor1 (vibration_sensor)
    i_vibration_sensor1 -> x_in.bind(s_vsource);
    i_vibration_sensor1 -> v_out.bind(s_sens_out);

    //i_sensor_frontend1 (sensor_frontend)
    i_sensor_frontend1 -> inp.bind(s_sens_out);
    i_sensor_frontend1 -> out.bind(adc);
    i_sensor_frontend1 -> k.bind(k);




/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//    initialize struct for external(e.g. tb)  access                      //
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

  c = new components(
                       i_vibration_src1,
                       i_vibration_sensor1,
                       i_sensor_frontend1,
                       s_vsource,
                       s_sens_out
                     );

}


 ////////////////////////////////////////////////////////////////////////////
 ////////////////////////////////////////////////////////////////////////////
 ////////////////////////////////////////////////////////////////////////////


//constructor implementation
top_level::top_level(sc_module_name name, params pa) :
          //naming ports for debugging
          adc("adc"),
          k("k"),
          p(pa)
{

     architecture();
}

//destructor implementation
top_level::~top_level()
{

    //delete component structure
    delete c;
}



#endif //#ifdef FHG_INCLUDE_IMPLEMENTATION

}  //end namespace vibration_sensor_namespace

//remove temporary defines
#undef DONT_INCLUDE_HIERARCHIC_COMPONENTS
#undef FHG_INCLUDE_IMPLEMENTATION


