/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: source
//
// MODULE NAME:  vibration_src
//
// DESCRIPTION OF MODULE:
//      /* Waveform generator module to output a sequence of sinusoidal wavelets */
//
// DESCRIPTION OF PORTS:
// out of type double
//      /* output uf source */
// DESCRIPTION OF PARAMETER:
// amplitude of type double
//      /* Amplitude of the sine wave */
// offset of type double
//      /* Offset of the sine wave */
// f_0 of type double
//      /* Base frequency of the sine wave */
// n_period of type int
//      /* Number of periods for one wavelet with f_0 */
// n_harmonic of type int
//      /* Number of harmonics in the wavelet sequence */
// T_0 of type double
//      /* Period of sine wave with f_0 */
// T_period of type double
//      /* Period of a sine wavelet */
//
// this file was generated by 'sca_xml2h.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////


#ifndef _VIBRATION_SENSOR_SOURCE_VIBRATION_SRC_H_
#define _VIBRATION_SENSOR_SOURCE_VIBRATION_SRC_H_

#include <systemc-ams.h>


namespace vibration_sensor_namespace
{

SCA_TDF_MODULE(vibration_src)
{
    // sca tdf ports
    sca_tdf::sca_out<double  > out;

    // parameters
    struct params
    {
        double  amplitude;
        double  offset;
        double  f_0;
        int n_period;
        int n_harmonic;
        double  T_0;
        double  T_period;

        params()
        {
            amplitude = 1.0;
            offset = 0.0;
            f_0 = 1.0;
            n_period = 1;
            n_harmonic = 3;
            T_0 = 1.0;
            T_period = 1.0;
        }
    } p;


    //methods
    void initialize();
    void processing();


    // constructor
    vibration_src(sc_core::sc_module_name nm, params pa = params() ) : out("out"),
                                                       p(pa),
                                                       s(create_states())
    {
        accept_attribute_changes();



    }

    // states
    struct states;
    states& s;
    states* operator -> () { return &s; }

    private:
        static states& create_states();

};



} //end namespace vibration_sensor_namespace
using namespace vibration_sensor_namespace;


#endif

#ifdef ACCESS_MODULE_STATE_DECLARATION
#ifndef _VIBRATION_SENSOR_SOURCE_VIBRATION_SRC_CPP_
#define _VIBRATION_SENSOR_SOURCE_VIBRATION_SRC_CPP_
#include "vibration_src.cpp"
#endif
#endif
