/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: frontend
//
// MODULE NAME:  gain_controller
//
// DESCRIPTION OF MODULE:
//      /* Gain Controller */
//
// DESCRIPTION OF PORTS:
// clk of type bool
//      /* clock input */
// amp_in of type sc_dt::sc_int<NBitsADC>
//      /* amplitude input */
//
// k_out of type int
//      /* gain output */
//
// DESCRIPTION OF PARAMETER:
// low_threshold of type int
//      
// high_threshold of type int
//      
// k_0 of type int
//      
// k_min of type int
//      
// k_max of type int
//      
// n_samples_avr of type long
//      /* number of samples for average */
//
// this file was generated by 'sca_xml2h.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////


#ifndef _VIBRATION_SENSOR_FRONTEND_GAIN_CONTROLLER_H_
#define _VIBRATION_SENSOR_FRONTEND_GAIN_CONTROLLER_H_

#include <systemc.h>


// user specified includes
#include "global_constants.h"


namespace vibration_sensor_namespace
{

SC_MODULE(gain_controller)
{
    // sc ports
    sc_core::sc_in<bool  > clk;
    sc_core::sc_in<sc_dt::sc_int<NBitsADC>  > amp_in;
    sc_core::sc_out<int  > k_out;

    // parameters
    struct params
    {
        int  low_threshold;
        int  high_threshold;
        int  k_0;
        int  k_min;
        int  k_max;
        long  n_samples_avr;

        params()
        {
            low_threshold = 0.2 * ((1 << (NBits - 1)) - 1);
            high_threshold = 0.66 * ((1 << (NBits - 1)) - 1);
            k_0 = 0;
            k_min = 0;
            k_max = 16;
            n_samples_avr = 1;
        }
    } p;


    // user methods
    void  state_init();

    void abs_ampl_avr();
    void adapt_gain();



    SC_HAS_PROCESS(gain_controller);

    // constructor
    gain_controller(sc_core::sc_module_name nm, params pa = params() ) : clk("clk"),
                                                       amp_in("amp_in"),
                                                       k_out("k_out"),
                                                       p(pa),
                                                       s(create_states())
    {

        SC_METHOD(abs_ampl_avr);
        sensitive << clk.pos();

        SC_METHOD(adapt_gain);


        sc_assert(p.low_threshold > 0);
        sc_assert(p.low_threshold < p.high_threshold);
        sc_assert(p.high_threshold < ((1 << (NBits - 1)) - 1));
        sc_assert(p.k_min < p.k_max);
        sc_assert(p.k_min <= p.k_0 && p.k_0 <= p.k_max);
        
        state_init();
        
    }

    // states
    struct states;
    states& s;
    states* operator -> () { return &s; }

    private:
        static states& create_states();

};



} //end namespace vibration_sensor_namespace
using namespace vibration_sensor_namespace;


#endif

#ifdef ACCESS_MODULE_STATE_DECLARATION
#ifndef _VIBRATION_SENSOR_FRONTEND_GAIN_CONTROLLER_CPP_
#define _VIBRATION_SENSOR_FRONTEND_GAIN_CONTROLLER_CPP_
#include "gain_controller.cpp"
#endif
#endif
