/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: frontend
//
// MODULE NAME:  adc
//
// DESCRIPTION OF MODULE:
//      /* Analog to digital converter */
//
// DESCRIPTION OF PORTS:
// in of type double
//      /* adc input */
// out of type sc_dt::sc_int<NBitsADC>
//      /* adc output */
// clk of type bool
//      /* clk which triggers adc conversion */
// DESCRIPTION OF PARAMETER:
// v_max of type double
//      
//
// this file was generated by 'sca_xml2h.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////


#ifndef _VIBRATION_SENSOR_FRONTEND_ADC_H_
#define _VIBRATION_SENSOR_FRONTEND_ADC_H_

#include <systemc-ams.h>


// user specified includes
#include "global_constants.h"


namespace vibration_sensor_namespace
{

SCA_TDF_MODULE(adc)
{
    // sca tdf ports
    sca_tdf::sca_in<double  > in;
    sca_tdf::sca_out<sc_dt::sc_int<NBitsADC>  > out;
    sca_tdf::sc_in<bool  > clk;

    // parameters
    struct params
    {
        double  v_max;

        params()
        {
            v_max = 1.0;
        }
    } p;


    //methods
    void initialize();
    void processing();
    void change_attributes();

    void set_attributes()
    {
        set_timestep(10.0,SC_US);
    }

    // constructor
    adc(sc_core::sc_module_name nm, params pa = params() ) : in("in"),
                                                       out("out"),
                                                       clk("clk"),
                                                       p(pa),
                                                       s(create_states())
    {
        does_attribute_changes();



    }

    // states
    struct states;
    states& s;
    states* operator -> () { return &s; }

    private:
        static states& create_states();

};



} //end namespace vibration_sensor_namespace
using namespace vibration_sensor_namespace;


#endif

#ifdef ACCESS_MODULE_STATE_DECLARATION
#ifndef _VIBRATION_SENSOR_FRONTEND_ADC_CPP_
#define _VIBRATION_SENSOR_FRONTEND_ADC_CPP_
#include "adc.cpp"
#endif
#endif
