// This test shows how to use analysis port for OVM with VMM notify

`define VMM_ON_TOP

`include "ovm_macros.svh"
`include "ovm_vmm_pkg.sv"
 
`include "ovm_apb_rw.sv"
`include "vmm_apb_rw.sv"
`include "apb_rw_converters.sv"

`include "ovm_producers.sv"
`include "vmm_consumers.sv"


class env extends `VMM_ENV;

 
  ovm_publish #(ovm_apb_rw) sender;
  vmm_watcher #(vmm_apb_rw) observer;
  apb_analysis2notify       ap2ntfy;
   
   `ovm_build
  virtual function void build();
    super.build();
    ovm_build();

    sender = new("sender",ovm_top);
    observer = new("observer");
    ap2ntfy = new("ap2ntfy",ovm_top, observer.notify, observer.INCOMING);
    sender.out.connect(ap2ntfy.analysis_export);
  endfunction

  virtual task start();
    super.start();
    observer.start_xactor();
  endtask

  virtual task wait_for_end();
    super.wait_for_end();
    //Stop the simulation after 100 timeunits
    #100;
  endtask

   virtual task stop();
    super.stop();
    observer.stop_xactor();
  endtask

endclass


module example_15_ovm_analysis2vmm_notify;

  env e = new;

  initial begin
     e.build();
     #10;
     e.run();
  end

endmodule