/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// throw error when register_processing method is used in set_attributes

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( tdf_module )
{
    sca_tdf::sca_out<double> out;

    void set_attributes()
    {
        set_timestep(1, sc_core::SC_MS);

        // throw error: only allowed to use this method
        // during module construction
        ptr = static_cast<sca_module_method>(&tdf_module::my_processing);
        register_processing( ptr );
    }

    void initialize() {}

    void my_processing() {}
        
    SCA_CTOR( tdf_module ) {}

  private:
    sca_module_method ptr; // pointer to new method
};

int sc_main( int argn, char*[] )
{
  TEST_LABEL_START;

  if (argn == 1)
    sc_core::sc_report_handler::set_handler(test_util::report_handler);

  sca_tdf::sca_signal<double> sig;

  tdf_module mod1("mod1");
    mod1.out(sig);

  sc_core::sc_start(10, sc_core::SC_MS);

  TEST_LABEL_END_WITHOUT_ERROR;

  return 0;
}
