/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/
// test sca_tdf::sca_port and sca_tdf::sca_signal constructors
// and all valid binding combinations (see 4.1.2)

#include <systemc-ams>
#include "test_utilities.h"

#define WRITE(a) \
    std::cout << a.name() << " (" << a.kind() << ")" << std::endl

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_de::sca_in<double> input_de;
  sca_tdf::sca_out<double> output_1;

  SCA_CTOR( mod_a )
  : input_de("input_de"), output_1("output_1")
  {}
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double>  input_1;
  sca_tdf::sca_out<double> output_1;

  SCA_CTOR( mod_b )
  : input_1("input_1"), output_1("output_1")
  {}
};

SCA_TDF_MODULE( mod_c )
{
  sca_tdf::sca_in<double>  input_1;
  sca_tdf::sca_out<double> output_1;

  SCA_CTOR( mod_c )
  : input_1("input_1"), output_1("output_1")
  {}
};


SC_MODULE( mod_d )
{
  mod_b b;
  mod_c c;

  sca_tdf::sca_signal<double> sig_1;

  sca_tdf::sca_out<double> in_1;
  sca_tdf::sca_out<double> out_1;

  SC_CTOR( mod_d )
  : b("b"), c("c"),
    sig_1("sig_1"), in_1("in_1"), out_1("out_1")
  {
    b.input_1(in_1);   // bind sca_tdf::sca_in to sca_tdf::sca_in of parent
    b.output_1(sig_1); // bind sca_tdf::sca_out to sca_tdf::sca_signal
    c.input_1(sig_1);  // bind sca_tdf::sca_in to sca_tdf::sca_signal
    c.output_1(out_1); // bind sca_tdf::sca_out to sca_tdf::sca_out of parent
  }
};

SCA_TDF_MODULE( mod_e )
{
  sca_tdf::sca_in<double> in1;

  SCA_CTOR( mod_e )
  : in1( "in_1" )
  {}
};

SCA_TDF_MODULE( mod_f )
{
  sca_tdf::sca_in<double> in1;
  sca_tdf::sca_out<double> out1;

  sca_tdf::sca_de::sca_in<double>  in2_de;
  sca_tdf::sca_de::sca_in<double>  in3_de;
  sca_tdf::sca_de::sca_out<double> out2_de;

  SCA_CTOR( mod_f )
  : in1( "in_1" ), out1("out1"), in2_de("in1_de"), out2_de("out2_de")
  {}
};

SC_MODULE( mod_g )
{
  mod_e e;
  mod_f f;

  sca_tdf::sca_in<double>  in_1;
  sca_tdf::sca_out<double> out_1;

  sc_core::sc_in<double>  in_2_de;
  sc_core::sc_out<double> out_2_de;
  sc_core::sc_out<double> out_3_de;

  SC_CTOR( mod_g )
  : e("e"), f("f"), in_1("in_1")
  {
    e.in1(out_1);  // bind sca_tdf::sca_in to sca_tdf::sca_out of parent
    f.in1(in_1);   // bind sca_tdf::sca_in to sca_tdf::sca_in of parent
    f.out1(out_1); // bind sca_tdf::sca_out to sca_tdf::sca_out of parent
    f.in2_de(in_2_de);   // bind sca_tdf::sca_de::sca_in to sc_core::sc_in of parent
    f.in3_de(out_3_de);  // bind sca_tdf::sca_de::sca_in to sc_core::sc_out of parent
    f.out2_de(out_2_de); // bind sca_tdf::sca_de::sca_out to sc_core::sc_out of parent
  }
};

SCA_TDF_MODULE( mod_h )
{
  sca_tdf::sca_in<double>  input_1;

  SCA_CTOR( mod_h )
  : input_1("input_1")
  {}
};
int sc_main( int, char* [] )
{
  TEST_LABEL_START;

  sc_core::sc_signal<double> sig1_de;   
  sca_tdf::sca_signal<double> sig2;
  sca_tdf::sca_signal<double> sig3;
  sca_tdf::sca_signal<double> sig4;
  sc_core::sc_signal<double> sig5_de;
  sc_core::sc_signal<double> sig6_de;
  sc_core::sc_signal<double> sig7_de;

  mod_a a("a");
  a.input_de(sig1_de);
  a.output_1(sig2);

  mod_d d("d");
  d.in_1(sig2);
  d.out_1(sig3);

  mod_g g("g");
  g.in_1(sig3);
  g.out_1(sig4);
  g.in_2_de(sig5_de);
  g.out_2_de(sig6_de);
  g.out_2_de(sig7_de);

  mod_h h("h");
  h.input_1(sig4);

  WRITE(a.input_de);
  WRITE(a.output_1);
  WRITE(d.b.input_1);
  WRITE(d.b.output_1);
  WRITE(d.c.input_1);
  WRITE(d.c.output_1);
  WRITE(d.sig_1);
  WRITE(g.e.in1);
  WRITE(g.f.in1);
  WRITE(g.f.out1);
  WRITE(g.f.in2_de);
  WRITE(g.f.out2_de);
  WRITE(g.f.out2_de);
  WRITE(h.input_1);    

  TEST_LABEL_END;

  return 0;
}
