/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test if sca_tdf::sca_ltf_zp is derived from sc_core::sc_object

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE ( mod_a )
{
  SCA_CTOR( mod_a )
  {
    my_ltf = new sca_tdf::sca_ltf_zp();
    sc_core::sc_object* obj = my_ltf;

    if (obj)
    {
      std::cout << "object valid: " << obj->kind() << std::endl;
    }
  }

  ~mod_a()
  {
    delete my_ltf;
  }

 private:
  sca_tdf::sca_ltf_zp* my_ltf;
};

SCA_TDF_MODULE ( mod_b )
{
  SCA_CTOR( mod_b )
  {
    sca_tdf::sca_ltf_zp my_ltf("my_ltf");
    sc_core::sc_object* obj = &my_ltf;

    if (obj)
    {
      std::cout << "object valid: " << obj->kind() << std::endl;
      std::cout << "object name: " << obj->name() << std::endl;
    }
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  mod_a a("a");
  mod_b b("b");

  TEST_LABEL_END;

  return 0;
}
