/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test sca_tdf::sca_de::sca_out member function set_delay() and get_delay()

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<int> out;

  int val;

  void processing()
  {
    out.write(val);
    val++;
  }

  SCA_CTOR( mod_a ) : out("out"), val(10)
  {
  }
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<int> in;
  sca_tdf::sca_de::sca_out<int> out;

  int val;

  void set_attributes()
  {
    out.set_delay(out_delay);
    sca_core::sca_time t(1.0, sc_core::SC_MS);
    out.set_timestep(t);
  }

  void initialize()
  {
    for (int i = 0; i<out_delay; i++)
    {
      out.initialize(i+80, i);
    }
    std::cout << "out.set_delay() set to: " << out_delay << std::endl;
    std::cout << "out.get_delay(): " << out.get_delay() << std::endl;
  }

  void processing()
  {
    val = in.read();
    out.write(val);
  }

  SCA_CTOR( mod_b ) : in("in"), out("out"), val(0), out_delay(2)
  {
  }

private:
  int out_delay;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<int> tdf_sig;
  sc_core::sc_signal<int> sc_sig;

  mod_a a("a");
    a.out(tdf_sig);

  mod_b b("b");
    b.in(tdf_sig);
    b.out(sc_sig);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test04");

  sca_util::sca_trace(atf, tdf_sig, "tdf_sig");
  sca_util::sca_trace(atf, sc_sig, "sc_sig");

  sc_core::sc_start(10.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test04", 2);
  
  TEST_LABEL_END;

  return 0;
}
