/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test sca_tdf::sca_in and sca_tdf::sca_out member function set_timestep(t)
// and using operator= for port read and write

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    sca_core::sca_time t(1, sc_core::SC_MS);
    out.set_timestep(t);
  }

  void initialize()
  {
    std::cout << "out.name() : " << out.kind() << std::endl;
    std::cout << "out.get_timestep() : " << out.get_timestep() << std::endl;
  }

  void processing()
  {
    std::cout << out.get_time() << "\t" << val << "\t";
    out = val;
    val++;
  }

  SCA_CTOR( mod_a ) : out("out"), val(3.0)
  {}

private:
  double val;
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double> in;

  void set_attributes()
  {
    sca_core::sca_time t(1, sc_core::SC_MS);
    in.set_timestep(t);
  }

  void initialize()
  {
    std::cout << "in.name() : " << in.name() << std::endl;
    std::cout << "in.get_timestep() : " << in.get_timestep() << std::endl;
    std::cout << "---------------" << std::endl;
    std::cout << "time_out\tout\ttime_in\tin" << std::endl;
  }

  void processing()
  {
    in_val = in;
    std::cout << in.get_time() << "\t" << in_val << std::endl;
  }

  SCA_CTOR( mod_b) : in("in"), in_val(0.0)
  {}

 private:
  double in_val;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig;

  mod_a a("a");
    a.out(sig);

  mod_b b("b");
    b.in(sig);

  sc_core::sc_start(10, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
