/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test LSF->TDF conversion of primitive sca_lsf::sca_tdf::sca_sink

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_lsf::sca_source source("source");
  sca_lsf::sca_tdf::sca_sink conv("conv");
  
  sca_lsf::sca_signal lsf_sig;
  sca_tdf::sca_signal<double> tdf_sig;

  source.y(lsf_sig);
  source.amplitude = 1.0;
  source.frequency = 0.1;
  
  conv.x(lsf_sig);
  conv.outp(tdf_sig);
  conv.scale = 2.0;
  conv.set_timestep(1.0, sc_core::SC_SEC);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test04");

  sca_util::sca_trace(atf, lsf_sig, "lsf_sig");
  sca_util::sca_trace(atf, tdf_sig, "tdf_sig");

  sc_core::sc_start(5.0, sc_core::SC_SEC);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test04", 2);

  TEST_LABEL_END;

  return 0;
}
