/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test LSF binding combinations (see 4.2.2)

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(top_model)
{
  sca_lsf::sca_in x;
  sca_lsf::sca_out y;

  sca_lsf::sca_gain gain1, gain2;
  sca_lsf::sca_dot dot1;
  sca_lsf::sca_add add1;

  top_model( sc_core::sc_module_name, double k1, double k2 )
  : x("x"), y("y"), 
    gain1("gain1", k1), gain2("gain2", k2), dot1("dot1"), add1("add1"),
    sig1("sig1"), sig2("sig2"), sig3("sig3")
  {
    gain1.x(x);  // bind child sca_lsf::sca_in port to sca_lsf::sca_in port of parent
    gain1.y(sig1);
    gain1.set_timestep(1, sc_core::SC_MS);

    add1.x1(sig1); // bind child sca_lsf::sca_in port to sca_lsf::sca_signal
    add1.x2(sig3);
    add1.y(sig2);  // bind child sca_lsf::sca_out port to sca_lsf::sca_signal

    dot1.x(sig2);
    dot1.y(y);    // bind child sca_lsf::sca_out port to sca_lsf::sca_out port of parent

    gain2.x(y);   // bind child sca_lsf::sca_in port to sca_lsf::sca_out port of parent
    gain2.y(sig3);
  }
 private:
  sca_lsf::sca_signal sig1, sig2, sig3;
};

int sc_main(int argc, char* argv[])
{
  TEST_LABEL_START;
  
  sca_lsf::sca_signal s1, s2;
  
  top_model mod("mod", 1.0, 1.0); 
    mod.x(s1);
    mod.y(s2);

  TEST_LABEL_END;
  
  return 0;  
}
