/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test amplification of sca_lsf::sca_gain using pointers

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_lsf::sca_source* src1;
  sca_lsf::sca_gain* gain1;
  sca_lsf::sca_signal sig1, sig2;
  
  src1 = new sca_lsf::sca_source("src1", 0.0, 2.0);
   src1->y(sig1);

  gain1 = new sca_lsf::sca_gain("gain1", 1.0);
   gain1->x(sig1);
   gain1->y(sig2);
   gain1->set_timestep(1.0, sc_core::SC_MS);
  
  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test04");

  sca_util::sca_trace(atf, sig1, "sig1");
  sca_util::sca_trace(atf, sig2, "sig2");

  sc_core::sc_start(5.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test04", 2);

  TEST_LABEL_END;

  delete src1, gain1;
  
  return 0;
}
