/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test derivation of primitive sca_lsf::sca_dot

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( src_ramp )
{
  sca_tdf::sca_out<double> out;

  void processing()
  {
    out.write(val);
    val += 1.0;
  }

  SCA_CTOR( src_ramp ) : out("out"), val(0)
  {}
  
private:
  double val;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  src_ramp ramp("ramp");
  sca_lsf::sca_tdf::sca_source conv("conv");
  sca_lsf::sca_dot dot("dot");
  sca_lsf::sca_integ integ("integ");
  
  sca_tdf::sca_signal<double> sig1;
  sca_lsf::sca_signal sig2, sig3, sig4;

  ramp.out(sig1);
  
  conv.inp(sig1);
  conv.y(sig2);

  dot.x(sig2);
  dot.y(sig3);
  //default gain k = 1
  dot.set_timestep(1.0, sc_core::SC_SEC);

  // dummy integer, signals not analysed
  integ.x(sig3);
  integ.y(sig4);
  
  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test01");

  sca_util::sca_trace(atf, sig1, "tdf_sig1");
  sca_util::sca_trace(atf, sig2, "lsf_sig2");
  sca_util::sca_trace(atf, sig3, "lsf_sig3");

  sc_core::sc_start(5.0, sc_core::SC_SEC);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test01", 3);

  TEST_LABEL_END;

  return 0;
}
