/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test kind() function and constructor arguments of sca_lsf::sca_delay

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_lsf::sca_delay delay("delay");

  std::cout << "delay.kind(): " << delay.kind() << std::endl;

  std::cout << "delay.x.kind(): " << delay.x.kind() << std::endl;
  std::cout << "delay.x.name(): " << delay.x.name() << std::endl;

  std::cout << "delay.y.kind(): " << delay.y.kind() << std::endl;
  std::cout << "delay.y.name(): " << delay.y.name() << std::endl;

  std::cout << "delay.k.kind(): " << delay.k.kind() << std::endl;
  std::cout << "delay.k.name(): " << delay.k.name() << std::endl;
  std::cout << "value delay.k: " << delay.k << std::endl;

  std::cout << "delay.y0.kind(): " << delay.y0.kind() << std::endl;
  std::cout << "delay.y0.name(): " << delay.y0.name() << std::endl;
  std::cout << "value delay.y0: " << delay.y0 << std::endl;

  TEST_LABEL_END;

  return 0;
}
