/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/
// test DE->LSF scaled conversion of primitive sca_lsf::sca_de::sca_source

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE( src_ramp )
{
  sc_core::sc_out<double> out;

  void ramp_thread()
  {
    while (true)
    {
      out.write(val);
      wait(sc_core::sc_time(1.0, sc_core::SC_SEC));
      val += 1.0;
    }
  }

  SC_CTOR( src_ramp ) : out("out"), val(0.25)
  { 
    SC_THREAD(ramp_thread);
  }
  
private:
  double val;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  src_ramp ramp("ramp");
  sca_lsf::sca_de::sca_source* conv;
  
  sc_core::sc_signal<double> de_sig;
  sca_lsf::sca_signal lsf_sig;

  ramp.out(de_sig);

  conv = new sca_lsf::sca_de::sca_source("conv", 2.0);
  conv->inp(de_sig);
  conv->y(lsf_sig);
  conv->set_timestep(1.0, sc_core::SC_SEC);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test05");

  sca_util::sca_trace(atf, de_sig, "de_sig");
  sca_util::sca_trace(atf, lsf_sig, "lsf_sig");

  sc_core::sc_start(5.0, sc_core::SC_SEC);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test05", 2);

  TEST_LABEL_END;

  delete conv;
  
  return 0;
}
