/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test simulation cycle for SystemC-AMS 2.0 dtdf

#include <systemc-ams>
#include "test_utilities.h"

bool is_time_not_equal(const sca_core::sca_time& t1, const sca_core::sca_time& t2)
{
  sca_core::sca_time tdiff;
  if (t1 > t2) tdiff = t1 - t2;
  else         tdiff = t2 - t1;
  return tdiff > sc_core::sc_get_time_resolution();
}

SCA_TDF_MODULE( mod_a )
{
  void print_status()
  {
    std::cout << "   are_attribute_changes_allowed: " << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
    std::cout << "   is_dynamic:                    " << (is_dynamic() ? "yes" : "no") << std::endl;
    std::cout << "   are_attributes_changed:        " << (are_attributes_changed() ? "yes" : "no") << std::endl;
    std::cout << "   is_timestep_changed:           " << (is_timestep_changed() ? "yes" : "no") << std::endl;
    std::cout << "   get_timestep:                  " << get_timestep() << std::endl;
    std::cout << "   get_last_timestep:             " << get_last_timestep() << std::endl;
    std::cout << "   get_max_timestep:              " << get_max_timestep() << std::endl;
    std::cout << "   get_time:                      " << get_time() << std::endl;
    std::cout << std::endl;
  }

  void set_attributes()
  {
    std::cout << "set_attributes()" << std::endl;

    set_timestep(1.0, sc_core::SC_MS);
    set_max_timestep(1.3, sc_core::SC_MS);
    request_next_activation(1.5, sc_core::SC_MS);

    std::cout <<
        "      request_next_activation(1.5,sc_core::SC_MS);\n"
        "      set_timestep(1.0,sc_core::SC_MS);\n"
        "      set_max_timestep(1.3,sc_core::SC_MS)" << std::endl;
  }

  void initialize()
  {
    std::cout << "-------------------------------------------------------------------------" << std::endl << std::endl;
    std::cout << get_time() << " initialize()" << std::endl;
    print_status();

    last_time_step = this->get_timestep();
    last_time = this->get_time() - this->get_timestep(); // for the first timestep the propagated value is returned
  }

  void reinitialize()
  {
    std::cout << "-------------------------------------------------------------------------" << std::endl << std::endl;
    std::cout << get_time() << " reinitialize()"  << std::endl;
    print_status();
  }

  void processing()
  {
    std::cout << "------------------------------------------" << std::endl;
    std::cout << get_time() << " processing()"  << std::endl;
    print_status();
    cnt++;

    //// Consistency checks ///////////////////////////

    if (is_time_not_equal(this->get_time() - last_time, this->get_timestep()))
    {
      std::ostringstream str;
      str << "Wrong timestep expect: " << this->get_time() - last_time;
      str << " last_time: " << last_time << " current time: " << this->get_time();
      str << " get_timestep: " << this->get_timestep();
      SC_REPORT_ERROR("Check", str.str().c_str());

    }
    last_time = this->get_time();

    if (is_time_not_equal(last_time_step, this->get_last_timestep()))
    {
      std::ostringstream str;
      str << "Wrong last timestep expect: " << last_time_step;
      str << " get_last_timestep: " << this->get_last_timestep();
      SC_REPORT_ERROR("Check", str.str().c_str());
    }
    last_time_step = this->get_timestep();
  }

  void change_attributes()
  {
    std::cout << "------------------------------------------" << std::endl;
    std::cout << get_time() << " change_attributes() cnt: " << cnt << std::endl;
    print_status();

    switch(cnt)
    {
    case 1:
        does_attribute_changes();
        std::cout << "      does_attribute_changes();" << std::endl;
      break;
    case 2:
      // the order has no influence, due consistency check is after
      // change_attribute execution
      request_next_activation(1.5, sc_core::SC_MS);
      does_attribute_changes();
      std::cout << "------------------------------------------" << std::endl;
      std::cout << "      request_next_activation(1.5,sc_core::SC_MS);" << std::endl;
      std::cout << "      does_attribute_changes();" << std::endl;
      break;
    case 3:
      does_no_attribute_changes();
      request_next_activation(0.5, sc_core::SC_MS);
      std::cout << "------------------------------------------" << std::endl;
      std::cout << "      does_no_attribute_changes();" << std::endl;
      std::cout << "      request_next_activation(0.5,sc_core::SC_MS);" << std::endl;
      break;
    case 4:
      does_attribute_changes();
      std::cout << "------------------------------------------" << std::endl;
      std::cout << "      does_attribute_changes();" << std::endl;
      break;
    case 5:
      does_attribute_changes();
      set_timestep(0.9, sc_core::SC_MS);
      request_next_activation(1.5, sc_core::SC_MS);
      std::cout << "------------------------------------------" << std::endl;
      std::cout << "      request_next_activation(1.5,sc_core::SC_MS);\n"
          "      set_timestep(0.9,sc_core::SC_MS);" << std::endl;
      break;
    case 6:
      break;
    case 7:
      does_attribute_changes();
      set_max_timestep(1.1, sc_core::SC_MS);
      request_next_activation(1.5, sc_core::SC_MS);
      std::cout << "------------------------------------------" << std::endl;
      std::cout << "      does_attribute_changes();" << std::endl;
      std::cout << "      request_next_activation(1.5,sc_core::SC_MS);\n"
          "      set_max_timestep(1.1,sc_core::SC_MS);" << std::endl;
      break;
    case 8:
      does_no_attribute_changes();
      std::cout << "------------------------------------------" << std::endl;
      std::cout << "      does_no_attribute_changes();" << std::endl;
      break;
    case 9:
        does_attribute_changes();
        std::cout << "------------------------------------------" << std::endl;
        std::cout << "      does_attribute_changes();" << std::endl;
      break;
    case 10:

      request_next_activation(1.5, sc_core::SC_MS);
      std::cout << "------------------------------------------" << std::endl;
      std::cout << "      request_next_activation(1.5,sc_core::SC_MS);" << std::endl;
      break;
    case 11:
      does_no_attribute_changes();
      std::cout << "------------------------------------------" << std::endl;
      std::cout << "      does_no_attribute_changes()" << std::endl;
      break;
    case 12:
      break;
    default:
      sc_core::sc_stop();
      break;
    }
  }

  SCA_CTOR( mod_a ) : cnt(0)
  {
  }

private:
  long cnt;
  sca_core::sca_time last_time;
  sca_core::sca_time last_time_step;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  mod_a a("a");

  sc_core::sc_start();

  TEST_LABEL_END;

  return 0;
}
