/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

//  set_sink_change_sink_idb.cpp
//    -- Test TDF-DE in bool port set_timestep() in the context of
//      change_attributes() after set_timestep() on the module in
//       set_attributes().

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(src)
{
  sca_tdf::sca_out<int> out;

  SCA_CTOR(src)
  : out("out"), i(0)
  {}

  void set_attributes()
  {
    accept_attribute_changes();
  }

  void processing()
  {
    out.write(++i);
  }

private:
  int i;
};

SCA_TDF_MODULE(sink)
{
  sca_tdf::sca_in<int> in;
  sca_tdf::sca_de::sca_in<bool> ind;

  SCA_CTOR(sink)
  : in("in"), ind("ind"), i(0), period(10), d(false)
  {}

  void set_attributes()
  {
    does_attribute_changes();
    accept_attribute_changes();
    this->set_timestep(1.0, sc_core::SC_US );
  }

  void processing()
  {
    i = in.read();
    d = ind.read();
  }

  void change_attributes()
  {
    if ( !(i % period) )
    {
      ind.set_timestep( (i / period) + 1, sc_core::SC_US );
    }
  }

private:
  int i, period;
  bool d;
};

int sc_main(int argc, char* argv[])
{
  using namespace sc_core;

  TEST_LABEL_START;

  sca_tdf::sca_signal <int> sig1("sig1");
  sc_clock sig2("sig2", 1, SC_US);

  src src1("src1");
  src1.out(sig1);

  sink sink1("sink1");
  sink1.in(sig1);
  sink1.ind(sig2);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("set_sink_change_sink_idb");
  sca_util::sca_trace(atf, sig1, "sig1");
  sca_util::sca_trace(atf, sig2, "sig2");

  atf->set_mode( sca_util::sca_multirate( sca_util::SCA_DONT_INTERPOLATE ) );

  sc_time tstop(100.0, SC_US);

  try
  {
    sc_start(tstop);
  }
  catch (const std::exception& e)
  {
    std::cerr << e.what() << std::endl;
  }

  sc_stop();

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("set_sink_change_sink_idb", 2);

  TEST_LABEL_END;

  return sc_report_handler::get_count(SC_ERROR);
}

// vim: expandtab : tabstop=2 : softtabstop=2 : shiftwidth=2
