/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test sca_ss for SystemC-AMS 2.0 dtdf -
// correct integration with variable timesteps

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_ss ss1, ss2, ss3, ss4;
  sca_util::sca_vector<double> s1, s4;
  sca_util::sca_matrix<double> A, B, C, D;

  void set_attributes()
  {
    set_timestep(1.0, sc_core::SC_MS);
    does_attribute_changes();
  }

  void initialize()
  {
    A(0, 0) = 0.0;
    B(0, 0) = 1.0;  // ds=x
    C(0, 0) = 1.0;  // y=s  -> y=integr(x)
    D(0, 0) = 0.0;
  }

  void reinitialize()
  {
  }

  void processing()
  {
    sca_util::sca_vector<double> one;
    one(0) = 1.0;

    sca_util::sca_vector<double> out1 = ss1(A, B, C, D, s1, one);
    sca_util::sca_vector<double> out2 = ss2(A, B, C, D, one);

    if (std::fabs(get_time().to_seconds() - out1(0)) > out1(0) / 1e12)
    {
      std::ostringstream str;
      str << "Unexpected result for out1: " << out1(0) << " at: "
          << get_time().to_seconds() << " sec";
      SC_REPORT_ERROR("Check", str.str().c_str());
    }

    if (std::fabs(get_time().to_seconds() - out2(0)) > out2(0) / 1e12)
    {
      std::ostringstream str;
      str << "Unexpected result for out2: " << out2(0) << " at: "
          << get_time().to_seconds() << " sec";
      SC_REPORT_ERROR("Check", str.str().c_str());
    }

    ///////////////////////////////////////////////////////

    sca_util::sca_vector<double> out3 = ss3(A, B, C, D, one, get_timestep() / 3);

    if (get_time() > sc_core::SC_ZERO_TIME)
    {
      double exv = (get_time() - get_timestep() + get_timestep() / 3).to_seconds();

      if (std::fabs(exv - out3(0)) > out3(0) / 1e12)
      {
        std::ostringstream str;
        str << "Unexpected result for out3 (partial timestep): " << out3(0) << " at: "
            << exv << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());
      }
    }
    else
    {
      if (std::fabs(out3(0)) > 1e-32)
      {
        std::ostringstream str;
        str << "Unexpected result for out3 (dc-value): " << out3(0) << " at: "
            << 0 << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());

      }
    }

    out3 = ss3(A, B, C, D, one);

    if (std::fabs(get_time().to_seconds() - out3(0)) > out3(0) / 1e12)
    {
      std::ostringstream str;
      str << "Unexpected result for out3: " << out3(0) << " at: "
          << get_time().to_seconds() << " sec";
      SC_REPORT_ERROR("Check", str.str().c_str());
    }

    ///////////////////////////////////////////////////////

    sca_util::sca_vector<double> out4 = ss4(A, B, C, D, s4, one, get_timestep() / 4);

    if (get_time() > sc_core::SC_ZERO_TIME)
    {
      double exv=(get_time() - get_timestep() + get_timestep() / 4).to_seconds();

      if (std::fabs(exv - out4(0)) > out4(0) / 1e12)
      {
        std::ostringstream str;
        str << "Unexpected result for out4 (partial timestep): " << out4(0) << " at: "
            << exv << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());
      }
    }
    else
    {
      if (std::fabs(out4(0)) > 1e-32)
      {
        std::ostringstream str;
        str << "Unexpected result for out4 (dc-value): " << out4(0) << " at: "
            << 0 << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());

      }
    }

    out4 = ss4(A, B, C, D, s4, one, get_timestep() / 3);

    if (get_time() > sc_core::SC_ZERO_TIME)
    {
      double exv = (get_time() - get_timestep() +
          get_timestep() / 4 +
          get_timestep() / 3).to_seconds();

      if (std::fabs(exv - out4(0)) > out4(0) / 1e12)
      {
        std::ostringstream str;
        str << "Unexpected result for out4 (partial timestep): " << out4(0) << " at: "
            << exv << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());
      }
    }
    else
    {
      if (std::fabs(out4(0)) > 1e-32)
      {
        std::ostringstream str;
        str << "Unexpected result for out4 (dc-value): " << out4(0) << " at: "
            << 0 << " sec";
        SC_REPORT_ERROR("Check", str.str().c_str());
      }
    }

    out4 = ss4(A, B, C, D, s4, one);

    if (std::fabs(get_time().to_seconds() - out4(0)) > out4(0) / 1e12)
    {
      std::ostringstream str;
      str << "Unexpected result for out4: " << out4(0) << " at: "
          << get_time().to_seconds() << " sec";
      SC_REPORT_ERROR("Check", str.str().c_str());
    }
  }

  void change_attributes()
  {
    switch(cnt)
    {
      case 0:
      case 1:
        break;
      case 2:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 3:
        break;
      case 4:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 5:
        request_next_activation(0.6, sc_core::SC_MS);
        break;
      case 6:
        break;
      case 7:
        set_timestep(0.3, sc_core::SC_MS);
        break;
      case 8:
        break;
      case 9:
        set_timestep(1.3, sc_core::SC_MS);
        break;
      case 10:
        break;
      case 11:
        request_next_activation(1.5, sc_core::SC_MS);
        break;
      case 12:
        break;
      case 13:
        set_max_timestep(0.7, sc_core::SC_MS);
        break;
      case 14:
        break;
      case 15:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 16:
        break;
      case 17:
        request_next_activation(0.5, sc_core::SC_MS);
        break;
      case 18:
        request_next_activation(0.8, sc_core::SC_MS);
        set_max_timestep(1.0, sc_core::SC_MS);
        break;
      default:
        sc_core::sc_stop();
        break;
    }
    cnt++;
  }

  SCA_CTOR( mod_a )
  : ss1("ss1"), ss2("ss2"), ss3("ss3"), ss4("ss4"), cnt(0)
  {
  }
  
 private:
  long cnt;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  mod_a a("a");

  sc_core::sc_start();

  TEST_LABEL_END;

  return 0;
}
