/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test Dynamic TDF for SystemC AMS 2.0
// use case 2g:
//   All modules accept attribute changes
//   Module A and B do attribute changes and both
//   implement change_attributes(); Module A after 2s and module B after 3s
//    (no resolution needed). Module A specifies it does not change attribute
//    anymore after 5s.
//   Result: Dynamic TDF cluster


#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    set_timestep( 1.0, sc_core::SC_MS );
    accept_attribute_changes();
    does_attribute_changes();
  }

  void initialize()
  {
    std::cout << "initialize @" << get_time() << ": mod_" << name() << ": is_dynamic? "
              << (is_dynamic() ? "yes" : "no") << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }

  void change_attributes()
  {
    double t = get_time().to_seconds();
    if (t == 2.0e-3)
    {
      set_timestep( 2.0, sc_core::SC_MS );
      std::cout << "change_att @" << get_time() << ": mod_" << name()
                << " timestep changed to 2ms" << std::endl;
    }

    if (t == 5.0e-3)
    {
      does_no_attribute_changes();
      std::cout << "change_att @" << get_time() << ": mod_" << name()
                << " does not allow to change attributes anymore" << std::endl;
    }

    std::cout << "change_att @" << get_time() << ": mod_" << name()
              << ": is_dynamic? " << (is_dynamic() ? "yes" : "no")
              << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }
  void processing()
  {
    std::cout << "processing @" << get_time() << ": mod_" << name() << ": is_dynamic? "
              << (is_dynamic() ? "yes" : "no") << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }

  void reinitialize()
  {
    std::cout << "reinitiali @" << get_time() << ": mod_" << name() << ": is_dynamic? "
              << (is_dynamic() ? "yes" : "no") << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }

  SCA_CTOR( mod_a ) : out("out") {}
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    accept_attribute_changes();
    does_attribute_changes();
  }

  void change_attributes()
  {
    double t = get_time().to_seconds();
    if (t == 4.0e-3)
    {
      set_timestep( 1.0, sc_core::SC_MS );
      std::cout << "change_att @" << get_time() << ": mod_" << name()
                << " timestep changed to 1ms" << std::endl;
    }
    std::cout << "change_att @" << get_time() << ": mod_" << name() << ": is_dynamic? "
              << (is_dynamic() ? "yes" : "no") << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }

  void initialize()
  {
    std::cout << "initialize @" << get_time() << ": mod_" << name() << ": is_dynamic? "
              << (is_dynamic() ? "yes" : "no") << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }

  void processing()
  {
    std::cout << "processing @" << get_time() << ": mod_" << name() << ": is_dynamic? "
              << (is_dynamic() ? "yes" : "no") << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }

  void reinitialize()
  {
    std::cout << "reinitiali @" << get_time() << ": mod_" << name() << ": is_dynamic? "
              << (is_dynamic() ? "yes" : "no") << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }

  SCA_CTOR( mod_b ) : in("in"), out("out") {}
};

SCA_TDF_MODULE( mod_c )
{
  sca_tdf::sca_in<double> in;

  void set_attributes()
  {
    accept_attribute_changes();
  }

  void initialize()
  {
    std::cout << "initialize @" << get_time() << ": mod_" << name() << ": is_dynamic? "
              << (is_dynamic() ? "yes" : "no") << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }

  void change_attributes()
  {
    std::cout << "change_att @" << get_time() << ": mod_" << name() << ": is_dynamic? "
              << (is_dynamic() ? "yes" : "no") << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }

  void processing()
  {
    std::cout << "processing @" << get_time() << ": mod_" << name() << ": is_dynamic? "
              << (is_dynamic() ? "yes" : "no") << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }

  void reinitialize()
  {
    std::cout << "reinitiali @" << get_time() << ": mod_" << name() << ": is_dynamic? "
              << (is_dynamic() ? "yes" : "no") << " ; are_attribute_changes_allowed?: "
              << (are_attribute_changes_allowed() ? "yes" : "no") << std::endl;
  }

  SCA_CTOR( mod_c ) : in("in") {}
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1, sig2;

  mod_a a("a");
    a.out(sig1);

  mod_b b("b");
    b.in(sig1);
    b.out(sig2);

  mod_c c("c");
    c.in(sig2);

  sc_core::sc_start(10.0, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
