/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test event mechanism of converter ports - use of event list

//----------------------------------------------------------------------------
// 5.1.1.13. request_next_activation
// ...
// template<class T>
// void request_next_activation( const sca_tdf::sca_de::sca_in<T>& );
//
// The next module activation is requested when the event, which is returned
// by the member function default_event of the port, passed as an argument,
// is notified.
//----------------------------------------------------------------------------

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(my_event_detection)
{
  sca_tdf::sca_de::sca_in<bool> inp1;
  sca_tdf::sca_de::sca_in<bool> inp2;

  SCA_CTOR(my_event_detection) : inp1("inp1"), inp2("inp2") {}

  void set_attributes()
  {
    does_attribute_changes();
    set_timestep(1.0, sc_core::SC_MS);
  }

  void processing()
  {
    bool val1 = inp1.read();
    bool val2 = inp2.read();
    std::cout << "@" << get_time() << "  processing called, val1 = " << (val1 ? "true" : "false") << std::endl;
    std::cout << "@" << get_time() << "  processing called, val2 = " << (val2 ? "true" : "false") << std::endl;
  }

  void change_attributes()
  {
    sc_core::sc_event_or_list el = ( inp1->default_event() | inp2->default_event() );
    request_next_activation(el);
  }
};

SC_MODULE(stimuli)
{
  sc_core::sc_out<bool> out1;
  sc_core::sc_out<bool> out2;

  void do_event()
  {
    wait(1.23, sc_core::SC_MS);
    out1.write(true);
    wait(1.33, sc_core::SC_MS);
    out2.write(false);
    wait(0.21, sc_core::SC_MS);
    out1.write(false);
    out2.write(true);
  }

  SC_CTOR(stimuli) : out1("out1"), out2("out2")
  {
    SC_THREAD(do_event);
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sc_core::sc_signal<bool> s1, s2;

  stimuli s("s");
  s.out1(s1);
  s.out2(s2);

  my_event_detection a("a");
  a.inp1(s1);
  a.inp2(s2);

  sc_core::sc_start(10, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
