/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test event mechanism of converter ports

//----------------------------------------------------------------------------
// 5.1.1.13. request_next_activation
// ...
// template<class T>
// void request_next_activation( const sca_tdf::sca_de::sca_in<T>& );
//
// The next module activation is requested when the event, which is returned
// by the member function default_event of the port, passed as an argument,
// is notified.
//----------------------------------------------------------------------------

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(my_event_detection)
{
  sca_tdf::sca_de::sca_in<int> inp;

  SCA_CTOR(my_event_detection) : inp("inp") {}

  void set_attributes()
  {
    does_attribute_changes();
    set_timestep(1.0, sc_core::SC_MS);
  }

  void processing()
  {
    int val = inp.read();
    std::cout << "@" << get_time() << "  processing called, value = " << val << std::endl;
  }

  void change_attributes()
  {
    request_next_activation(inp);
  }
};

SC_MODULE(generate_event)
{
  sc_core::sc_out<int> out;

  void do_event()
  {
    wait(1.23, sc_core::SC_MS);
    out.write(4);
  }

  SC_CTOR(generate_event) : out("out")
  {
    SC_THREAD(do_event);
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sc_core::sc_signal<int> s1;

  generate_event e("e");
  e.out(s1);

  my_event_detection a("a");
  a.inp(s1);

  sc_core::sc_start(10, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
