/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

//  counter.h -- Generic counter module with out port sca_tdf::sca_out<T, Pol>.

#ifndef COUNTER_SRC_H
#define COUNTER_SRC_H

#include <systemc-ams>

// Generic counter module with out port sca_tdf::sca_out<T, Pol, Delay>.
template<class T, sca_tdf::sca_cut_policy Pol>
class counter : public sca_tdf::sca_module
{
 public:
  sca_tdf::sca_out<T, Pol>  out;

  counter ( sc_core::sc_module_name nm, T value_, sca_core::sca_time ts_, unsigned long delay_ = 0 )  
  : sca_tdf::sca_module(nm), out("out"), count(value_), ts(ts_), delay(delay_)
  {}

  void set_attributes() 
  {
    accept_attribute_changes();
    out.set_timestep(ts);
    out.set_delay(delay);
  }

  void initialize() 
  {
    for (int i = 0; i < delay; ++i)
    {
      out.initialize(-delay + i + count, i);
    }
    out.set_initial_value(-7);
  }

  void processing()
  {
    out.write(int(count));
    count += 1;
  }

 private:
  T count;
  sca_core::sca_time ts;
  unsigned long delay;
};  // class counter

#endif  // COUNTER_H

// vim: expandtab : tabstop=2 : softtabstop=2 : shiftwidth=2
