/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/
// test for ac noise implementation of
// of a port of class sca_tdf::sca_out<T, sca_tdf::SCA_CT_CUT>

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double, sca_tdf::SCA_CT_CUT> out;

  void set_attributes()
  {
    out.set_timestep(1.0, sc_core::SC_US);
    out.set_delay(1); // mandatory for CT decoupling port
  }

  void initialize()
  {
    out.initialize(0.0, 0);
  }

  void ac_processing()
  {
    using namespace sca_ac_analysis;
    sca_ac_noise(out) = sca_ac_z(-1) * sca_ac_analysis::sca_ac_f();
  }

  void processing()
  {
    out = 1.0;
  }

  SCA_CTOR( mod_a ) : out("out")
  {
  }
};

///////////////////////////////////////////////////////////////////////////////

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double>  in;
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    in.set_timestep(1.1, sc_core::SC_US);
  }

  void ac_processing()
  {
    sca_util::sca_complex res;
    res = sca_ac_analysis::sca_ac(in);
    sca_ac_analysis::sca_ac(out) = res;
  }

  void processing()
  {
    out = in;
  }

  SCA_CTOR( mod_b ) : in("in"), out("out")
  {
  }
};

///////////////////////////////////////////////////////////////////////////////

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig_in, sig_out;

  mod_a a("mod_a");
    a.out(sig_in);

  mod_b b("mod_b");
    b.in(sig_in);
    b.out(sig_out);

  sca_util::sca_trace_file* tf1 = sca_util::sca_create_tabular_trace_file("test02");
  sca_util::sca_trace(tf1, sig_in,  "sig_in");
  sca_util::sca_trace(tf1, sig_out, "sig_out");

  sca_ac_analysis::sca_ac_noise_start(1.0, 2e6, 1000, sca_ac_analysis::SCA_LOG);

  sca_util::sca_close_tabular_trace_file(tf1);

  test_util::check_results("test02", 5);

  TEST_LABEL_END;

  return 0;
}
