/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#ifndef DIFF_H
#define DIFF_H

#include <systemc-ams>

SCA_TDF_MODULE(diff)
{
  sca_tdf::sca_in<double> ref, meas;
  sca_tdf::sca_out<double> err;

  SCA_CTOR(diff)
  : ref("ref"), meas("meas"), err("err")
  {}

  void set_attributes()
  {
    err.set_delay(1); // essential - system has control loop
  }

  void processing()
  {
    err.write( ref.read() - meas.read() );
  }
};

#endif // DIFF_H

/*
 * Local Variables:
 * mode: C++
 * End:
 */
