/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// my_tdf_sink from user's guide

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(my_const_source)
{
  // port declaration
  sca_tdf::sca_out<double> out;

  my_const_source( sc_core::sc_module_name, double val_ = 1.0 )
  : out("out"), val( val_ ) {}

  void processing()
  {
    out.write( val ); // Writes val as a new sample to the port out

    std::cout << "value (val) written:" << val << std::endl;
  }

 private:
  double val; // value to be written to the port
};

SCA_TDF_MODULE(my_tdf_sink)
{
  // port declaration
  sca_tdf::sca_in<double> in;

  SCA_CTOR(my_tdf_sink) : in("in") {}

  void set_attributes()
  {
    in.set_timestep(1, sc_core::SC_MS);
  }

  void processing()
  {
    // local variable
    double ret; // return value ( should be the same data type as the port type )
    ret = in.read(); // reading first sample from the input port

    std::cout << "value (ret) read:" << ret << std::endl;
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig;

  my_const_source src("src");
  my_tdf_sink sink("sink");

  src.out(sig);
  sink.in(sig);

  sc_core::sc_start(3, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}

