/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// my_tdf_module from user's guide

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(my_tdf_module)
{
  // port declarations
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double> out;

  sca_tdf::sca_de::sca_in<bool> inp;
  sca_tdf::sca_de::sca_out< sc_dt::sc_logic> outp;

  SCA_CTOR(my_tdf_module)
  {
    val = 0.0;
  }

  // additional constructor with parameter
  my_tdf_module( sc_core::sc_module_name nm, double param_ )
  : param(param_) {}

  void set_attributes()
  {
    // module attributes, see section 2.2.1
    set_timestep(10.0, sc_core::SC_MS); // set timestep of module activation

    // see section 2.2.2
    out.set_timestep(0.01, sc_core::SC_US); // set timestep of port out
    out.set_rate(1); // set rate of port out to 1
    out.set_delay(2); // set delay of port out to 2 samples
    outp.set_timeoffset(0.2, sc_core::SC_US); // set actual time of first sample of converter port outp
  }

  void initialize()
  {
    // initial values

    // set local state variable 's' (private data member of type double)
    s = 4.56;

    // get time step of output port 'out'
    std::cout << out.name() << ": Time step = " << out.get_timestep() << std::endl;

    // initialize output port 'out'
    out.initialize(1.23); // initialize first sample with value 1.23

    // see section 2.2.2
    out.get_rate(); // return the rate of port out
    out.get_delay(); // return the delay of port out
    outp.get_timestep(); // return actual timestep of converter port outp
    outp.get_timeoffset(); // return absolute time of first sample of converter port outp

    // initialize port out (which has a delay attribute of 2)
    out.initialize(1.23); // initialize first sample with value 1.23 or
    out.initialize(1.23, 0); // initialize first sample with value 1.23
    out.initialize(4.56, 1); // initialize second sample with value 4.56
  }

  void processing()
  {
    // signal processing behavior or algorithm

    out.write(val); // writes value to output port out

    sca_core::sca_time local_time;
    local_time = get_time(); // get actual, local module time
  }

 private:
  double s;
  double val;
  double param;
};

class my_second_module : public sca_tdf::sca_module
{
 public:
  // port declarations
  // ...

  my_second_module( sc_core::sc_module_name ) {}
  // similar member functions as above
  // ...

};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  my_tdf_module a1("a1");

  my_tdf_module a2("a2", 1.1);

  my_second_module b("b");

  std::cout << a1.name() << std::endl;
  std::cout << a2.name() << std::endl;
  std::cout << b.name() << std::endl;

  TEST_LABEL_END;

  return 0;
}


