/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// user's guide examples my_tdf_interp and my_tdf_decim

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(my_source)
{
  sca_tdf::sca_out<double> out;

  SCA_CTOR(my_source) : out("out") {}

  void set_attributes()
  {
    out.set_timestep(1, sc_core::SC_MS);
  }

  void processing()
  {
    out.write(1.0);
  }
};

SCA_TDF_MODULE(my_tdf_interp)
{
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double> out;

  SCA_CTOR(my_tdf_interp) : in("in"), out("out") {}

  void set_attributes()
  {
    out.set_rate(2);
  }

  void processing()
  {
    out.write( in.read() ); // input sample directly fed to the output
    out.write( 0.0, 1 );    // insert zero as 2nd sample
  }
};

SCA_TDF_MODULE(my_tdf_decim)
{
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double> out;

  SCA_CTOR(my_tdf_decim) : in("in"), out("out") {}

  void set_attributes()
  {
    in.set_rate(2);
  }

  void processing()
  {
    out.write( in.read() ); // only write the first sample and neglect the second one
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1, sig2, sig3;
  
  my_source src("src");
    src.out(sig1);

  my_tdf_interp interp("interp");
    interp.in(sig1);
    interp.out(sig2);

  my_tdf_decim decim("decim");
    decim.in(sig2);
    decim.out(sig3);

  sca_util::sca_trace_file* tf = sca_util::sca_create_tabular_trace_file("my_tdf_interp_decim");

  sca_util::sca_trace(tf, sig1, "sig1");
  sca_util::sca_trace(tf, sig2, "sig2");
  sca_util::sca_trace(tf, sig3, "sig3");

  sc_core::sc_start(12, sc_core::SC_MS);
  
  sca_util::sca_close_tabular_trace_file(tf);

  test_util::check_results("my_tdf_interp_decim", 3);
  
  TEST_LABEL_END;
    
  return 0;
}
  
