/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// user's guide example my_tdf_delay

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(my_source)
{
  sca_tdf::sca_out<double> out;

  SCA_CTOR(my_source) : out("out") {}

  void set_attributes()
  {
    out.set_timestep(1, sc_core::SC_MS);
  }

  void processing()
  {
    out.write(1.0);
  }
};

SCA_TDF_MODULE(my_tdf_delay)
{
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double> out;

  SCA_CTOR(my_tdf_delay) : in("in"), out("out") {}

  void set_attributes()
  {
    out.set_delay(1);
  }

  void initialize()
  {
    out.initialize(1.1);
  }

  void processing()
  {
    out.write( in.read() ); // directly write the input sample to the output (incl the delay)
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1, sig2;
  
  my_source src("src");
    src.out(sig1);

  my_tdf_delay delay("delay");
    delay.in(sig1);
    delay.out(sig2);
    
  sc_core::sc_start(12, sc_core::SC_MS);
  
  TEST_LABEL_END;
    
  return 0;
}
