/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// user's guide PID controller with external control

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(stub)
{
  sca_tdf::sca_out<double> out;

  stub( sc_core::sc_module_name, double val_) : out("out"), val(val_) {}

  void processing()
  {
    out.write(val);
  }

 private:
  double val;
};

SC_MODULE(lsf_pid_external_control)
{
  sca_lsf::sca_in  in;
  sca_lsf::sca_out out;

  sca_tdf::sca_in<double> p, i, d; // adjustable coefficients

  sca_lsf::sca_tdf::sca_gain  gain_p, gain_i, gain_d; // coefficients used to scale the gain
  sca_lsf::sca_integ integ;
  sca_lsf::sca_dot   dot;
  sca_lsf::sca_add   add1, add2;

  lsf_pid_external_control( sc_core::sc_module_name name )
  : in("in"), out("out"), p("p"), i("i"), d("d"),
    gain_p("gain_p"), gain_i("gain_i"), gain_d("gain_d"),
    integ("integ"), dot("dot"), add1("add1"), add2("add2"),
    sig_gain("sig_gain"), sig_integ1("sig_integ1"), sig_integ2("sig_integ2"), 
    sig_dot1("sig_dot1"), sig_dot2("sig_dot2"),    
    sig_add("sig_add")
  {
    gain_p.x(in);
    gain_p.y(sig_gain);
    gain_p.inp(p);

    gain_i.x(in);
    gain_i.y(sig_integ1);
    gain_i.inp(i);

    gain_d.x(in);
    gain_d.y(sig_dot1);
    gain_d.inp(d);

    integ.x(sig_integ1);
    integ.y(sig_integ2);
    
    dot.x(sig_dot1);
    dot.y(sig_dot2);

    add1.x1(sig_gain);
    add1.x2(sig_integ2);
    add1.y(sig_add);

    add2.x1(sig_add);
    add2.x2(sig_dot2);
    add2.y(out);
  }
 
 private:
  sca_lsf::sca_signal sig_gain, sig_integ1, sig_integ2, sig_dot1, sig_dot2, sig_add;
};

int sc_main( int, char*[] )
{
  sc_core::sc_set_time_resolution(1.0, sc_core::SC_FS);

  TEST_LABEL_START;

  sca_lsf::sca_signal in, out;
  
  sca_tdf::sca_signal<double> pext, iext, dext;

  stub stub1("stub1", 1.0);
    stub1.out(pext);
  stub stub2("stub2", 1.0);
    stub2.out(iext);
  stub stub3("stub3", 1.0);
    stub3.out(dext);

  sca_lsf::sca_source src("src", 0.0, 1.0); // step of 1 unit at t=0
    src.y(in);
    src.set_timestep(100, sc_core::SC_MS);
  
  lsf_pid_external_control pid("pid");
    pid.in(in);
    pid.out(out);
    pid.p(pext);
    pid.i(iext);
    pid.d(dext);

  sc_core::sc_start(10.0, sc_core::SC_MS);

  TEST_LABEL_END;
    
  return 0;
}
