/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// user's guide exampler where header will import none of the namespaces

#include <systemc-ams>
#include "test_utilities.h"

#include "my_source.h"

int sc_main(int argc, char* argv[])
{
  sc_core::sc_set_time_resolution(1.0, sc_core::SC_FS);

  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1;

  // instantiate user-defined module from user-defined 'my_tdf' namespace
  my_tdf::my_source i_my_source("i_my_source");
  i_my_source.out(sig1);

  // instantiate other modules
  //...

  // tracing AMS signals
  sca_util::sca_trace_file* tf = sca_util::sca_create_tabular_trace_file("trace.dat");
  sca_util::sca_trace(tf, sig1, "sig1");

  sc_core::sc_start(10, sc_core::SC_MS);

  tf->set_mode(sca_util::sca_ac_format(sca_util::SCA_AC_MAG_RAD));

  sca_ac_analysis::sca_ac_start(1.0e3, 1.0e6, 4, sca_ac_analysis::SCA_LOG);
  
  sca_util::sca_close_tabular_trace_file(tf);

  TEST_LABEL_END;
    
  return 0;
}
