/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// user's guide example my_eln_filter

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(my_eln_filter)
{
  sca_eln::sca_terminal a;
  sca_eln::sca_terminal b;

  sca_eln::sca_r r1;
  sca_eln::sca_c c1;
  
  my_eln_filter( sc_core::sc_module_name, double r1_value, double c1_value )
  : a("a"), b("b"), r1("r1", r1_value), c1("c1", c1_value ), gnd("gnd")
  {
  r1.n(a);
  r1.p(b);

  c1.n(b);
  c1.p(gnd);
  }

 private:
  sca_eln::sca_node_ref gnd;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_eln::sca_node n1, n2;
  sca_eln::sca_node_ref gnd;
  
  sca_eln::sca_vsource vin("vin", 0.0, 1.0);
    vin.p(n1);
    vin.n(gnd);
    vin.set_timestep(0.1, sc_core::SC_MS);
    
  my_eln_filter filter1("filter1", 1.0e3, 1.0e-6);
    filter1.a(n1);
    filter1.b(n2);

  sca_util::sca_trace_file* tf =
  sca_util::sca_create_tabular_trace_file("my_eln_filter");

  sca_util::sca_trace(tf, n1, "n1");
  sca_util::sca_trace(tf, n2, "n2");
  
  sc_core::sc_start(6.0, sc_core::SC_MS);
  
  sca_util::sca_close_tabular_trace_file(tf);

  test_util::check_results("my_eln_filter", 2);

  TEST_LABEL_END;

  return 0;
}
