/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#include <systemc-ams>

SCA_TDF_MODULE( drv_motor )
{
  sca_tdf::sca_in<double> in;
  sca_tdf::sca_out<double> out;

  drv_motor( sc_core::sc_module_name nm )
  : in("in"), out("out"), 
    ltf_zp("ltf_zp"), h0(255.0), omega0(20.0)
  {}

  void initialize()
  {
    // no zeros required
    poles(0) = sca_util::sca_complex( -omega0 , 0.0 );
  }

  void processing()
  {
    double tmp = ltf_zp( zeros, poles, in.read(), h0 * omega0 );
    out.write(tmp);
  }

 private:
  double h0, omega0;
  sca_tdf::sca_ltf_zp ltf_zp; // Laplace transfer function
  sca_util::sca_vector<sca_util::sca_complex> poles, zeros; // poles and zeros as complex values
};

