/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test of sca_core::sca_port constructors for sc_signal_in(inout)_if interface 

#include <systemc-ams>
#include "test_utilities.h"

#define WRITE(a) \
    std::cout << a.name() << " (" << a.() << ")" << std::endl

template <class T>
class myport: public sca_core::sca_port<sc_core::sc_signal_in_if<T> >
{};

SC_MODULE( mod_a )
{
  myport<double> in1;
  myport<double> in2;

  // no names assigned to ports, as there is no constructor for this
  SC_CTOR( mod_a )
  : in1(), in2()
  {}
};

SC_MODULE( mod_b )
{
  myport<double> in1;
  myport<double> in2;

  // no names assigned to ports, as there is no constructor for this
  SC_CTOR( mod_b )
  : in1(), in2()
  {}
};

int sc_main( int, char* [] )
{
  TEST_LABEL_START;

  mod_a a("a");

  TEST_LABEL_END;

  return 0;
}
