/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// conservative_view_recursion.cpp --
// problem reported at http://forums.accellera.org/topic/6041-large-system-simulation-problem/

#include <systemc-ams>
#include <systemc>
#include <iostream>
#include "test_utilities.h"
SCA_TDF_MODULE(incr)
{
  sca_tdf::sca_in<long> inp {"inp"};
  sca_tdf::sca_out<long> outp {"outp"};

  void processing()
  {
    outp = inp.read()+1;
  }

  SCA_CTOR(incr) {}
};

template<long N>
SCA_TDF_MODULE(check)
{
  sca_tdf::sca_in<long> inp {"inp"};
  sca_tdf::sca_out<long> outp {"outp"};

  void set_attributes()
  {
    outp.set_delay(1);
    this->set_timestep(1.0, sc_core::SC_NS);
  }

  void initialize()
  {
    outp.initialize(0);
  }

  void processing()
  {
    long inv = inp.read();

    if (inv != last_inv+N)
    {
      std::ostringstream str;
      str << "wrong value: " << inv << " expected: " << last_inv+N;
      SC_REPORT_ERROR("Check", str.str().c_str());
      return;
    }

    last_inv = inv;
    outp.write(inv);

  }

  SCA_CTOR(check)
  {
    last_inv = 0;
  }

private:
  long last_inv;
};

///////////////////////////////////////////////////////////////////////////////

template<int N=1024>
SC_MODULE(tdfchain)
{
  check<N> i_check {"i_check"};

  sca_tdf::sca_signal<long> unnamedNet1 {"unnamedNet1"};
  sc_core::sc_vector<sca_tdf::sca_signal<long> > s_vec { "s_vec", N }; // signals between resistors
  sc_core::sc_vector<incr> mod_vec { "mod_vec", N };

  SC_CTOR(tdfchain)
  {
    i_check.inp(s_vec[N - 1]);
    i_check.outp(unnamedNet1);

    mod_vec[0].inp(unnamedNet1); // connect source to first module
    mod_vec[0].outp(s_vec[0]);   // connect port port of first module

    for (int i = 1; i < N - 1; i++)
    {
      mod_vec[i].inp(s_vec[i - 1]);
      mod_vec[i].outp(s_vec[i]);
    }

    mod_vec[N - 1].inp(s_vec[N - 2]);
    mod_vec[N - 1].outp(s_vec[N - 1]);
  }

};

int sc_main(int argc, char* argv[])
{
  TEST_LABEL_START;

  tdfchain<20000> cir("tdfchain");

  sc_core::sc_start(10.0, sc_core::SC_NS);

  TEST_LABEL_END;

  return (EXIT_SUCCESS);
}
