/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

#include <systemc-ams>
#include "test_utilities.h"

class signal_generator : public sca_tdf::sca_module
{
public :
  sca_tdf::sca_out<unsigned int > out;

  signal_generator(sc_core::sc_module_name name_, const double Ts_)
  : out("out"), Ts(Ts_)
  {}

  void set_attributes()
  {
    out.set_timestep(Ts, sc_core::SC_SEC);
  }

  void processing()
  {
    out.write(0x0);
  }

private :
  const double Ts;
};

int sc_main(int argc, char* argv[])
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<unsigned int> sig_out;

  signal_generator U_signal_generator("U_signal_generator", 1.0e-6 );
    U_signal_generator.out(sig_out);

  sc_core::sc_start(1.0, sc_core::SC_US);

  sc_core::sc_stop();

  TEST_LABEL_END;

  return (EXIT_SUCCESS);

} // sc_main


