/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

/*
 * checks, that module delta after sc_stop() does not lead to a segfault
 */

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(tdf_src)
{
  sca_tdf::sca_out<double> out ;

  SCA_CTOR(tdf_src)
  : out("out")
  {}

  void set_attributes()
  {
    set_timestep(1.0, sc_core::SC_US);
  }

  void processing()
  {
    double x = std::sin(2.0 * M_PI * 1.0e3 * get_time().to_seconds());
    out.write(x);
  }
};

/////////////////////////////////////////////////

int sc_main(int argc, char* argv[])
{
  sca_util::sca_information_off();

  sca_tdf::sca_signal<double> src_out;

  tdf_src* u_source = new tdf_src("u_source");
  u_source->out(src_out);

  sc_core::sc_start(10.0, sc_core::SC_MS);

  sc_core::sc_stop();

  TEST_LABEL_START;

  //here should no segfault happen
  delete u_source;

  TEST_LABEL_END;

  return (EXIT_SUCCESS);
}
