# SystemC AMS extensions regression test suite

This is the production release of the SystemC AMS regression test suite.

## Contents

 1. Organization
 2. Running tests
 3. Adding new tests

## 1. Organization

  The regression test suite is organized as follows. At the top level, we have
  the following directories:
  * `include`: directory containing additional utility and helper functions
  * `rundir`: directory as placeholder to run the regression
  * `scripts`: directory containing the running script
  * `tests`: directory containing the regresssion tests
  
  The `include` directory contains additional utility and helper
  functions for the calculations of results. It also contains some
  commonly used TDF modules, which are used in some tests. A custom
  report handler is available to capture errors or warnings.
   
  The `rundir` directory is an empty directory, which can be used
  by the  end-user to execute the regression. It is a considered a
  temporary directory and can be cleaned after running the regression.
  
  The `scripts` directory contains the regression test script(s).
  Right now, this directory contains a single script, `verify-ams.pl`.
  This script is written in perl. It works with `perl5`, which must be
  located in `/usr/bin` or `/usr/local/bin` of your local Unix/Linux 
  distribution.

  The `tests` directory contains the regression tests. The directory
  has a systemc-ams directory, which contain other directories.
  Actual tests are located in leaf directories.

  An actual test directory contains one or more source code files
  (ending in `.cpp`). If the directory contains one source code file,
  the name of the test is the filename (without extension) of that
  source code file. If the directory contains more than one source
  code file, there must be a file with extension `.f` that contains a
  list of source code files (one line per source code file, and the
  next higher directory must be added, e.g. `arith_big/main.cpp`). In
  this case, the name of the test is the filename (without extension)
  of the `.f` file.
  The actual test directory may contain property files that tell the
  regression test script how to deal with the actual test, e.g. a
  `COMPILE` file tells the regression test script to only compile the
  source code file(s), and a `DONTRUN` file tells the regression test
  script to skip the actual test directory. A `DONTRUN` file in a non-
  test directory tells the regression test script to skip the tests in
  all its subdirectories.
  The actual test directory may contain a `golden` directory, which
  contains one or more golden reference files (stripped). The
  filename of these files is the same as the test name (see above), and
  the extension starts with `.log`. Platform specific golden reference
  files append `.<platform>` to the file, e.g. `test.log.sparcOS5`.
  For many systemc-ams tests, a reference trace file with extension `.ref` 
  is available in the `golden` which allows comparison with the actual 
  traced data. 

## 2. Running tests

  Regression tests can be run by calling the `verify-ams.pl` 
  script. The script requires a Perl interpreter.

  NOTE: _do not_ put this script in your path, because the path to the
  script is used to determine where the regression tests are
  located.

  The `verify-ams.pl` script is located in the `scripts` 
  directory of the SystemC regression test suite. It requires the environment
  variables `SYSTEMC_HOME` and `SYSTEMC_AMS_HOME` to be set to your 
  installation. Furthermore, you must use the `CXX` environment 
  variable to select the appropriate target architecture, just like with 
  `configure` when configuring SystemC and SystemC AMS.

  Valid settings for `CXX` on the different platforms are:
  
    o g++       -> linux[64]
                -> windows (using mingw64 or cygwin)
    o clang++   -> linux[64]
                -> windows (using mingw64 or cygwin)
    o cl.exe    -> windows

  To set the variables to the Visual C++ compiler and linker, the script
  file `vsvars.bat` located in the `scripts` directory can be used.
  See the [RELEASENOTES](RELEASENOTES.md) for more information.

  Default, the `verify-ams.pl` script assumes that the tests are located
  in `../tests` (wrt the location of the script itself). This can be
  overrruled with environment variable `SYSTEMC_TEST`.

  It is recommended to use the `rundir` to run the tests.
  
  The `verify-ams.pl` script takes directories and names of tests as
  arguments. For example

  ```
  > cd rundir
  > ../scripts/verify-ams.pl systemc-ams
  ```

  runs all the tests in the regression test suite. The directories
  should be relative to `$SYSTEMC_TEST/tests`. By specifying
  subdirectories, it is possible to run only a subset of the tests in
  the regression test suite, e.g.

  ```
  > cd rundir
  > ../scripts/verify-ams.pl systemc-ams/core/sca_prim_channel
  ```

  will run only the SystemC AMS primitve channel regression tests. 
  And if the name of the test/directory is unique, one can enter instead

  ```
  > cd rundir
  > ../scripts/verify-ams.pl sca_prim_channel
  ```

  which will run the same tests.

  There are several options that can be specified with the `verify-ams.pl`
  script. Most notibly, `-f <file>` which can be used to have a file
  containing the tests you want to run, and `-v` to run with verbose
  output. In case the script is started without argument or is used 
  using the option `-h`, all available options are shown. 

  Note:
    Currently, not all options are fully implemented, and some may
    disappear in the future.

  The (temporary) results of the regression tests are stored in the
  current directory, i.e., the directory from where the `verify-ams.pl`
  script is called. Directories for tests that pass will be cleared
  (and if possible removed), unless the `-no-cleanup` option is
  specified. If a test fails all intermediate results will be
  kept. The directory structure of the (temporary) results is the same
  as the regression tests under `$SYSTEMC_TEST/tests`. Furthermore, in
  the current directory, a regression test log file called
  `verify-ams.log` is created. This file contains the output of running
  each of the tests, and it contains a summary of which tests failed
  (with the phase in which they failed) and which tests passed.

  Beware:
    It is recommended to use the `rundir` to run the tests, or
    create another _temporary_ directory to run the tests in. You
    should _never_ run the tests in the directory in which the test
    sources are located (i.e. `$SYSTEMC_TEST/tests`).

## 3. Adding new tests

  When adding tests to the SystemC AMS regression test suite, please stick
  to the following rules.

  - Group tests by feature.

  - Contributions of new tests should be put in a directory next to
    the `systemc-ams` directory. This directory could be called `incoming`.
    The person(s) responsible for the SystemC regression test suite can
    then decide when and how to put these tests into the suite.

  - Every test goes into its own directory. This directory must be a
    leaf directory, that is, it can contain a `golden` directory for
    the golden reference files, but it cannot contain directories
    holding other tests.

  - Source code files must end in `.cpp`.

  - If your test contains more than one source code file, you have to
    add a `.f` file, which lists the source code files (don't forget
    to prepend the current directory name -- just one level).

  - When running the test the first time, it will fail, because you
    don't have a golden reference file. To create this golden
    reference file, do the following.
      o Create the directory `golden` in your test directory.
      o Make sure that the temporary test file called
        `<your_test>.log.stripped` is correct.
      o Copy the above file in the `golden` directory in your test
        directory, and name it `<your_test>.log` or
        `<your_test>.log.<platform>` if you have different results on
        different platforms. If you do get different results on
        different platforms, you have to make sure that these
        differences are harmless and cannot be avoided (e.g. printing
        floating-point numbers with or without leading 0).
      o Now run your test again, and verify that it works now.

