/*
 * main.cpp
 *
 *  Created on: 2010-12-09
 *      Author: Nan Li
 */

#include "systemc.h"
#include "adm.h"
#include "adm_scheduler.h"

#include "sampdram.h"

#include "test_gen.h"

#include "command_line.h"

int sc_main(int argc, char *argv[]) {

	/* OCP parameters */
	map_string_type  ocpParamMap;
	std::string ocpFile, admFile;

	process_command_line(argc, argv, ocpFile, admFile);
	if (argc < 5) {
		cerr << "Usage: \n adm ocpParams admParams testFile logFile [ref] [mt [policy [rr_slot_size]]]" << endl;
		exit(1);
	}

	readMapFromFile(ocpFile, ocpParamMap);
	ocpip::ocp_parameters params = create_ocp_configuration_from_map("sl", ocpParamMap);

	sc_clock clk("clk", 5, SC_NS);

	adm_test_gen masterTest("master_test", argv[3], argv[4]);
	masterTest.ocpInitPort.set_ocp_config(params);
	masterTest.clk(clk);

	if ((argc >= 6) && !strcmp(argv[5], "ref")) {
		int delay = 1;
		if (argc >= 7)
			delay = atoi(argv[6]);

		sampdram<32, 32> ref("ref", delay);
		ref.ocpInitPort.set_ocp_config(params);
		ref.clk(clk);

		if ((argc < 8) || strcmp(argv[7], "mt")) {
			masterTest.ocpInitPort(ref.ocpInitPort);

			sc_start();

		} else {
			adm_scheduler<32>::scheduling_policy pol;
			uint64 rrSlotSize = 0;
			if (argc < 9)
				pol = adm_scheduler<32>::FIFO;
			else if (!strcmp(argv[8], "fifo"))
				pol = adm_scheduler<32>::FIFO;
			else if (!strcmp(argv[8], "prio"))
				pol = adm_scheduler<32>::PRIORITY;
			else if (!strcmp(argv[8], "rr")) {
				pol = adm_scheduler<32>::ROUND_ROBIN;
				rrSlotSize = atoi(argv[9]);
			} else
				pol = adm_scheduler<32>::FIFO;

			adm_scheduler<32> adm_sched("adm_scheduler", pol, rrSlotSize);

			adm_sched.ocpInitPort.set_ocp_config(params);
			adm_sched.ocpTargetPort.set_ocp_config(params);
			masterTest.ocpInitPort(adm_sched.ocpTargetPort);
			adm_sched.ocpInitPort(ref.ocpInitPort);

			adm_sched.clk(clk);

			sc_start();
		}

	} else {
		adm_model<32> adm("adm", ocpFile.c_str(), admFile.c_str());
		adm.clk(clk);

		if ((argc < 6) || strcmp(argv[5], "mt")) {
			masterTest.ocpInitPort(adm.ocpPort);

			sc_start();

		} else {
			adm_scheduler<32>::scheduling_policy pol;
			uint64 rrSlotSize = 0;
			if (argc < 7)
				pol = adm_scheduler<32>::FIFO;
			else if (!strcmp(argv[6], "fifo"))
				pol = adm_scheduler<32>::FIFO;
			else if (!strcmp(argv[6], "prio"))
				pol = adm_scheduler<32>::PRIORITY;
			else if (!strcmp(argv[6], "rr")) {
				pol = adm_scheduler<32>::ROUND_ROBIN;
				rrSlotSize = atoi(argv[7]);
			} else
				pol = adm_scheduler<32>::FIFO;

			adm_scheduler<32> adm_sched("adm_scheduler", pol, rrSlotSize);

			adm_sched.ocpInitPort.set_ocp_config(params);
			adm_sched.ocpTargetPort.set_ocp_config(params);
			masterTest.ocpInitPort(adm_sched.ocpTargetPort);
			adm_sched.ocpInitPort(adm.ocpPort);

			adm_sched.clk(clk);

			sc_start();
		}
	}

	return 0;
}
