/* Copyright
* ========================================================================================
* Project:       MAPPED DRAM
* Author:        Lei Liang, KTH
* ID:            RAM, v 1.0, 2010-11-16
*
* Description:	 A sample memory space instanced by MAP method.
* 				 The Data and Address length is same as the
* 				 OCP-IP communication model.Read and Write operation
* 				 contained in this head file.
*
* ========================================================================================
* Version History
* ========================================================================================
* Version 1.0: First executable version
* ========================================================================================
*/


#ifndef _MEMEM_H
#define _MEMEM_H

#include <iostream>
#include <map>
#include <string>
using std::endl;
using std::cout;


template <typename Tdatamem>
class Memorymem {
public:

   typedef typename Tdatamem::DataType Td;
   typedef typename Tdatamem::AddrType Ta;
   typedef std::map< Ta, unsigned char > mapMemType;



   /*This function is used to read data from the memory
    */
   Td read(Ta addr){
	   int i= sizeof(Td);
	   Td wholevalue=0;
	   for(; i>0 ; i--){
		   wholevalue=(wholevalue<<8);
		   wholevalue=(wholevalue | m_Memory[addr+i-1]);
	   }

	   return wholevalue;
   }

   /*This function is used to write data on the bus into the memory
    */
   void write(Ta addr, Td data){
	   int ii= sizeof(Td);
	   for (int i=0; i<ii; i++){
		   m_Memory[addr+i]=(data & 0x000000ff);
		   data=(data>>8);
	   }

   }

 private:

   mapMemType   m_Memory;
};

#endif //_MEMEM_H
