/*
 *  Copyright
 * ========================================================================================
 * Project:		Accurate DRAM Model
 * Author:		Yi Wang, KTH
 * ID:			adm_delay_submodel.h, v1.2, 2010/11/27
 *
 * Description:	An all in one header file for system that need to integrate this DRAM delay model
 *
 * ========================================================================================
 * Version History
 * ========================================================================================
 * Version 1.0: First Executable Version
 * Version 0.1: Draft version
 * ========================================================================================
 */

#ifndef DRAM_DELAY_SUBMODEL_H_
#define DRAM_DELAY_SUBMODEL_H_

#include "systemc.h"
#include "adm_request_decoder.h"
#include "adm_dram_core.h"

class adm_delay_submodel : public sc_module
{
public:
	/* IO ports */
	sc_in<bool> clock;
	sc_port<adm_ctrl_if>  dram_delay_initiator_port;
	sc_export<adm_dram_if> dram_delay_target_port;

	/* submodules */
	adm_request_decoder ard;
	adm_dram_core adc;

	/* constructor */
	adm_delay_submodel(sc_module_name nm, adm_configuration admConfig)
			: dram_delay_initiator_port("DRAM_Delay_Initiator_Port")
			, dram_delay_target_port("DRAM_Delay_Target_Port")
			, ard("request_decoder", admConfig)
			, adc("DRAM_core", admConfig)
	{
		ard.clk(clock);
		dram_delay_target_port(ard.decoder_target_port);
		ard.decoder_initiator_port(adc.core_target_port);
		adc.clk(clock);
		adc.core_initiator_port(dram_delay_initiator_port);
	}

};


#endif /* DRAM_DELAY_SUBMODEL_H_ */
