/**
 *
 * @file resource.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: resource.cc 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#include "resource.hh"
#include <boost/lexical_cast.hpp>
#include <iostream>

namespace sctg
{
   Resource::Resource(sc_core::sc_module_name name, 
		      const boost::property_tree::ptree& pt)
      : sc_core::sc_module(name)
   {
      _name = name;
      _id = pt.get<unsigned long int>("<xmlattr>.id");
      _freq = pt.get<unsigned long int>("<xmlattr>.frequency", 1);
      _type = pt.get<std::string>("<xmlattr>.type");
      
      // Parse terminals
      using boost::property_tree::ptree;
      for(ptree::const_iterator iter = pt.begin(); iter != pt.end(); ++iter)
      {
	 if((*iter).first == "port")
	 {
	    unsigned long int terminal = (*iter).second.get<unsigned long int>
	       ("<xmlattr>.terminal");
	    _terminals.push_back(terminal);
	 }
      }
      
      // // Find address for all terminals
//       for(unsigned int i = 0; i < _terminals.size(); ++i)
//       {
	 
//       }
      
   }
   
   Resource::~Resource()
   {
   }
   
   const std::string& Resource::getName() const
   { return _name; }
   
   unsigned long int Resource::getId() const
   { return _id; }
   
   unsigned long int Resource::getFrequency() const
   { return _freq; }
   
   const std::string& Resource::getType() const
   { return _type; }

   unsigned long int Resource::getTerminal() const // Support for one terminal!
   { return _terminals.at(0); };

   void Resource::setTerminal(unsigned long int terminal,
			      unsigned long int address,
			      unsigned long int width)
   {
      std::vector<unsigned long int>::iterator iter =
	 std::find(_terminals.begin(), _terminals.end(), terminal);
      if(iter != _terminals.end())
      {
	 _terminalAddress[terminal] = address;
	 _terminalWidth[terminal] = width;
      }
      else
      {
	 std::string err = "Resource " + getName() + 
	    " has no terminal with id " + 
	    boost::lexical_cast<std::string>(terminal);
	 throw std::runtime_error(err.c_str());
      }
   }

   unsigned long int Resource::getTerminalAddress(unsigned long int terminal) 
      const
   {
      std::map<unsigned long int, unsigned long int>::const_iterator iter =
	 _terminalAddress.find(terminal);
      if(iter != _terminalAddress.end())
      {
	 return iter->second;
      }
      else
      {
	 std::string err = "Resource " + getName() + 
	    " has no terminal with id " + 
	    boost::lexical_cast<std::string>(terminal);
	 throw std::runtime_error(err.c_str());
      }
   }
   

   unsigned long int Resource::getTerminalWidth(unsigned long int terminal) 
      const
   {
      std::map<unsigned long int, unsigned long int>::const_iterator iter =
	 _terminalWidth.find(terminal);
      if(iter != _terminalWidth.end())
      {
	 return iter->second;
      }
      else
      {
	 std::string err = "Resource " + getName() + 
	    " has no terminal with id " + 
	    boost::lexical_cast<std::string>(terminal);
	 throw std::runtime_error(err.c_str());
      }
   }
   
}


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
