/**
 *
 * @file noc_conf_if.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: noc_conf_if.hh 1407 2010-09-01 12:49:28Z lehton87 $
 *
 */

#ifndef SCTG_NOC_CONF_IF_HH
#define SCTG_NOC_CONF_IF_HH

#include <string>

namespace sctg
{
   class BufferInterface;

   class NocConfIf
   {
   public:
    
      virtual ~NocConfIf() {}

      virtual BufferInterface* getBufferIf(unsigned long int agent) = 0;

      virtual const std::string& getNocClass()   = 0;
      virtual const std::string& getNocType()    = 0;
      virtual const std::string& getNocSubType() = 0;

   };
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
