/**
 *
 * @file sbus_factory.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: sbus_factory.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#ifndef SBUS_NOC_FACTORY_HH
#define SBUS_NOC_FACTORY_HH

#include "sctg_to_osci_tlm.hh"
#include "simple_bus.hh"

#include "noc_conf_if.hh"

#include <systemc>

namespace asebt
{

   class SBusFactory
   {
   public:
      
      SBusFactory(sctg::NocConfIf* nocConfIf);
   
      virtual ~SBusFactory();      
      
   private:   
      
      sctg::SctgToOsciTlm<4, 32>* _adapter_4;
      asebt::SimpleBus<4, 32>*    _bus_4;

      sctg::SctgToOsciTlm<9, 32>* _adapter_9;
      asebt::SimpleBus<9, 32>*    _bus_9;

      sctg::SctgToOsciTlm<16, 32>* _adapter_16;
      asebt::SimpleBus<16, 32>*    _bus_16;

      sctg::SctgToOsciTlm<25, 32>* _adapter_25;
      asebt::SimpleBus<25, 32>*    _bus_25;

      sctg::SctgToOsciTlm<36, 32>* _adapter_36;
      asebt::SimpleBus<36, 32>*    _bus_36;

      sctg::SctgToOsciTlm<64, 32>* _adapter_64;
      asebt::SimpleBus<64, 32>*    _bus_64;
         
      SBusFactory(const SBusFactory& x);
      SBusFactory& operator=(const SBusFactory&);
   };
   
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
