/**
 *
 * @file tlm_1_factory.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: tlm_1_factory.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#ifndef MESH_2D_SC_TLM_1_FACTORY_HH
#define MESH_2D_SC_TLM_1_FACTORY_HH

#include "sctg_to_osci_tlm.hh"
#include "sc_tlm_1/tlm_mesh_2d.hh"
#include "noc_conf_if.hh"

#include <systemc>

namespace asebt
{
   namespace mesh_2d_sc_tlm_1
   {
      
      class Tlm1Factory
      {
      public:
	 
	 Tlm1Factory(sctg::NocConfIf* nocConfIf);
	 
	 virtual ~Tlm1Factory();
	 
      private:
	 
	 TlmMesh2D<32, 2, 2>*        _tlmMesh_2x2;
	 sctg::SctgToOsciTlm<4, 32>* _adapter_4;

	 TlmMesh2D<32, 3, 3>*        _tlmMesh_3x3;
	 sctg::SctgToOsciTlm<9, 32>* _adapter_9;

	 TlmMesh2D<32, 4, 4>*         _tlmMesh_4x4;
	 sctg::SctgToOsciTlm<16, 32>* _adapter_16;
	 
	 TlmMesh2D<32, 5, 5>*         _tlmMesh_5x5;
	 sctg::SctgToOsciTlm<25, 32>* _adapter_25;

	 TlmMesh2D<32, 6, 6>*         _tlmMesh_6x6;
	 sctg::SctgToOsciTlm<36, 32>* _adapter_36;

	 TlmMesh2D<32, 8, 8>*         _tlmMesh_8x8;
	 sctg::SctgToOsciTlm<64, 32>* _adapter_64;
	 
      };
      
   }
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
